//
//  enable_cxx.cpp
//  LiveRecognition
//
//  Copyright © 2025 Luxand, Inc. All rights reserved.
//

#include <stdio.h>
#include "CoreFoundation/CoreFoundation.h"
#include "LuxandFaceSDK.h"

int SwapChannels13I(unsigned char * pSrcDst, int srcDstScanLine, int width, int height, int mode);
int ChangeBoundleDirectory();

extern "C" {
    int CSwapChannels13I(unsigned char * pSrcDst, int srcDstScanLine, int width, int height, int mode) {
        return SwapChannels13I(pSrcDst, srcDstScanLine, width, height, mode);
    }
    int CChangeBoundleDirectory()
    {
        CFBundleRef mainBundle = CFBundleGetMainBundle();
           CFURLRef resourcesURL = CFBundleCopyResourcesDirectoryURL(mainBundle);
           char path[PATH_MAX];
           if (!CFURLGetFileSystemRepresentation(resourcesURL, TRUE, (UInt8 *)path, PATH_MAX))
           {
               // error!
               return -1;
           }
           CFRelease(resourcesURL);

           chdir(path);
           //std::cout << "Current Path: " << path << std::endl;
        return 0;
    }

    int FSDK_ActivateLibrarySwift(const char* licenseKey)
    {
        FSDK_SetParameter("Environment", "swift");
        return FSDK_ActivateLibrary(licenseKey);
    }
}


