//
//  AppDelegate.swift
//  PassiveLivenessRecognition
//
//  Copyright © 2025 Luxand, Inc. All rights reserved.
//

import Foundation
import UIKit

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {
    
    var window: UIWindow?
    var recognitionViewController: RecognitionViewController?
    
    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplicationLaunchOptionsKey: Any]?) -> Bool {
        
        
        var res: Int32 = FSDK_ActivateLibrarySwift(("INSERT THE LICENSE KEY HERE" as NSString).utf8String);
        
        NSLog("activation result: %d", res);
        if (res != FSDKE_OK) {
            exit(res);
        }
        
        res = FSDK_Initialize(nil);
        NSLog("initialization result: %d", res);
        
        CChangeBoundleDirectory();
        
        res = FSDK_SetParameter("LivenessModel", "external");
        if (res == FSDKE_OK) {
            NSLog("External liveness model initialized.");
        } else {
            NSLog("Liveness model initialization result: %d", res);
        }
        
        window = UIWindow.init(frame: UIScreen.main.bounds)
        window?.backgroundColor = UIColor.black
        window?.autoresizesSubviews = true
        window?.autoresizingMask = [ .flexibleWidth, .flexibleHeight ]
        
        recognitionViewController = RecognitionViewController(screen: UIScreen.main)
        window?.rootViewController = recognitionViewController
        
        window?.makeKeyAndVisible()
        window?.layoutSubviews()
        
        return true
    }
    
    func applicationWillResignActive(_ application: UIApplication) {
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
    }
    
    func applicationDidEnterBackground(_ application: UIApplication) {
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    }
    
    func applicationWillEnterForeground(_ application: UIApplication) {
        // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
    }
    
    func applicationDidBecomeActive(_ application: UIApplication) {
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    }
    
    func applicationWillTerminate(_ application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
        
        recognitionViewController?.closing = true
        
        var i = 0
        while (recognitionViewController?.processingImage == true) {
            i += 1
            if (i > 20) {
                break
            }
            Thread.sleep(forTimeInterval:0.1)
        }
        
        let tracker = recognitionViewController!.tracker
        let memoryPath = recognitionViewController?.memoryPath
        FSDK_SaveTrackerMemoryToFile(tracker, (memoryPath! as NSString).utf8String)
    }
}
