import { type FacePosition, type IDSimilarity, type NativeFunctionNumberResult, type Point, type TrackerID } from './NativeFaceSDK';
import { IMAGEMODE, ON_ERROR, VIDEOCOMPRESSIONTYPE, type FacialAttribute, type Parameter, type Parameters, type ParameterValue, type TrackerFacialAttribute, type TrackerParameter, type TrackerParameters } from './definitions';
import { type Frame } from 'react-native-vision-camera';
export interface FaceImage {
    image: number;
    features: Point[];
}
export declare function frameToFSDKImage(frame: Frame): NativeFunctionNumberResult;
export default class FSDK {
    static SetOnError(value: ON_ERROR): void;
    static ActivateLibrary(licenseKey: string): void;
    static Initialize(): void;
    static ActivateAndInitalize(licenseKey: string): void;
    static GetLicenseInfo(): string;
    static GetVersionInfo(): string;
    static CreateEmptyImage(): number;
    static FreeImage(image: number): void;
    static LoadImageFromFile(filename: string): number;
    static LoadImageFromFileWithAlpha(filename: string): number;
    static LoadImageFromBuffer(buffer: string, width: number, height: number, scanLine: number, imageMode: IMAGEMODE): number;
    static LoadImageFromJpegBuffer(buffer: string): number;
    static LoadImageFromPngBuffer(buffer: string): number;
    static LoadImageFromPngBufferWithAlpha(buffer: string): number;
    static LoadImageFromFrame(frame: Frame): number;
    static SaveImageToFile(image: number, filename: string): void;
    static SetJpegCompressionQuality(quality: number): void;
    static GetImageWidth(image: number): number;
    static GetImageHeight(image: number): number;
    static GetImageBufferSize(image: number, imageMode: IMAGEMODE): number;
    static SaveImageToBuffer(image: number, imageMode: IMAGEMODE): string;
    static CopyImage(image: number): number;
    static ResizeImage(image: number, ratio: number): number;
    static RotateImage90(image: number, multiplier: number): number;
    static RotateImage(image: number, angle: number): number;
    static RotateImageCenter(image: number, angle: number, x: number, y: number): number;
    static CopyRect(image: number, x1: number, y1: number, x2: number, y2: number): number;
    static CopyRectReplicateBorder(image: number, x1: number, y1: number, x2: number, y2: number): number;
    static MirrorImage(image: number, vertical?: boolean): void;
    static ExtractFaceImage(image: number, features: Point[], width: number, height: number): FaceImage;
    static DetectFace(image: number): FacePosition;
    static DetectMultipleFaces(image: number, maxFaces?: number): FacePosition[];
    static SetFaceDetectionParameters(handleArbitraryRotations: boolean, determineFaceRotationAngle: boolean, internalResizeWidth: number): void;
    static SetFaceDetectionThreshold(threshold: number): void;
    static GetDetectedFaceConfidence(): number;
    static DetectFacialFeatures(image: number): Point[];
    static DetectFacialFeaturesInRegion(image: number, position: FacePosition): Point[];
    static DetectEyes(image: number): Point[];
    static DetectEyesInRegion(image: number, position: FacePosition): Point[];
    static GetFaceTemplate(image: number): string;
    static GetFaceTemplateInRegion(image: number, position: FacePosition): string;
    static GetFaceTemplateUsingFeatures(image: number, features: Point[]): string;
    static GetFaceTemplateUsingEyes(image: number, eyes: Point[]): string;
    static MatchFaces(template1: string, template2: string): number;
    static GetMatchingThresholdAtFAR(far: number): number;
    static GetMatchingThresholdAtFRR(frr: number): number;
    static CreatTracker(): number;
    static LoadTrackerMemoryFromFile(filename: string): number;
    static LoadTrackerMemoryFromBuffer(buffer: string): number;
    static FreeTracker(tracker: number): void;
    static ClearTracker(tracker: number): void;
    static SaveTrackerMemoryToFile(tracker: number, filename: string): void;
    static GetTrackerMemoryBufferSize(tracker: number): number;
    static SaveTrackerMemoryToBuffer(tracker: number): string;
    static SetTrackerParameter(tracker: number, name: TrackerParameter, value: ParameterValue): void;
    static SetTrackerMultipleParameters<T extends TrackerParameter>(tracker: number, parameters: string | TrackerParameters<T>): number;
    static GetTrackerParameter(tracker: number, name: TrackerParameter, maxSize?: number): string;
    static FeedFrame(tracker: number, image: number, maxFaces?: number, index?: number): number[];
    static GetTrackerEyes(tracker: number, id: number, index?: number): Point[];
    static GetTrackerFacialFeatures(tracker: number, id: number, index?: number): Point[];
    static GetTrackerFacePosition(tracker: number, id: number, index?: number): FacePosition;
    static LockID(tracker: number, id: number): void;
    static UnlockID(tracker: number, id: number): void;
    static PurgeID(tracker: number, id: number): void;
    static SetName(tracker: number, id: number, name: string): void;
    static GetName(tracker: number, id: number, maxSize?: number): string;
    static GetAllNames(tracker: number, id: number, maxSize?: number): string;
    static GetIDReassignment(tracker: number, id: number): number;
    static GetSimilarIDCount(tracker: number, id: number): number;
    static GetSimilarIDList(tracker: number, id: number): number[];
    static GetTrackerIDsCount(tracker: number): number;
    static GetTrackerAllIDs(tracker: number): number[];
    static GetTrackerFaceIDsCountForID(tracker: number, id: number): number;
    static GetTrackerFaceIDsForID(tracker: number, id: number): number[];
    static GetTrackerIDByFaceID(tracker: number, faceID: number): number;
    static GetTrackerFaceTemplate(tracker: number, faceID: number): string;
    static GetTrackerFaceImage(tracker: number, faceID: number): number;
    static SetTrackerFaceImage(tracker: number, faceID: number, image: number): void;
    static DeleteTrackerFaceImage(tracker: number, faceID: number): void;
    static TrackerCreateID(tracker: number, template: string): TrackerID;
    static AddTrackerFaceTemplate(tracker: number, id: number, template: string): void;
    static DeleteTrackerFace(tracker: number, faceID: number): void;
    static TrackerMatchFaces(tracker: number, template: string, threshold: number, maxSize?: number): IDSimilarity[];
    static GetTrackerFacialAttribute(tracker: number, id: number, attribute: TrackerFacialAttribute | TrackerFacialAttribute[], maxSize?: number, index?: number): string;
    static DetectFacialAttributeUsingFeatures(image: number, features: Point[], attribute: FacialAttribute | FacialAttribute[], maxSize?: number): string;
    static GetValueConfidence(values: string, value: FacialAttribute | TrackerFacialAttribute): number;
    static SetParameter(name: Parameter, value: ParameterValue): void;
    static SetParameters<T extends Parameter>(parameters: string | Parameters<T>): void;
    static SetHTTPProxy(address: string, port: number, username: string, password: string): void;
    static OpenIPVideoCamera(comression: VIDEOCOMPRESSIONTYPE, url: string, username: string, password: string, timeout: number): number;
    static InitializeCapturing(): void;
    static FinalizeCapturing(): void;
    static GrabFrame(camera: number): number;
    static CloseVideoCamera(camera: number): void;
}
//# sourceMappingURL=FaceSDKWorklets.d.ts.map