"use strict";

import LuxandFaceSDK from "./NativeFaceSDK.js";
export let ERROR = /*#__PURE__*/function (ERROR) {
  ERROR[ERROR["OK"] = 0] = "OK";
  ERROR[ERROR["FAILED"] = -1] = "FAILED";
  ERROR[ERROR["NOT_ACTIVATED"] = -2] = "NOT_ACTIVATED";
  ERROR[ERROR["OUT_OF_MEMORY"] = -3] = "OUT_OF_MEMORY";
  ERROR[ERROR["INVALID_ARGUMENT"] = -4] = "INVALID_ARGUMENT";
  ERROR[ERROR["IO_ERROR"] = -5] = "IO_ERROR";
  ERROR[ERROR["IMAGE_TOO_SMALL"] = -6] = "IMAGE_TOO_SMALL";
  ERROR[ERROR["FACE_NOT_FOUND"] = -7] = "FACE_NOT_FOUND";
  ERROR[ERROR["INSUFFICIENT_BUFFER_SIZE"] = -8] = "INSUFFICIENT_BUFFER_SIZE";
  ERROR[ERROR["UNSUPPORTED_IMAGE_EXTENSION"] = -9] = "UNSUPPORTED_IMAGE_EXTENSION";
  ERROR[ERROR["CANNOT_OPEN_FILE"] = -10] = "CANNOT_OPEN_FILE";
  ERROR[ERROR["CANNOT_CREATE_FILE"] = -11] = "CANNOT_CREATE_FILE";
  ERROR[ERROR["BAD_FILE_FORMAT"] = -12] = "BAD_FILE_FORMAT";
  ERROR[ERROR["FILE_NOT_FOUND"] = -13] = "FILE_NOT_FOUND";
  ERROR[ERROR["CONNECTION_CLOSED"] = -14] = "CONNECTION_CLOSED";
  ERROR[ERROR["CONNECTION_FAILED"] = -15] = "CONNECTION_FAILED";
  ERROR[ERROR["IP_INIT_FAILED"] = -16] = "IP_INIT_FAILED";
  ERROR[ERROR["NEED_SERVER_ACTIVATION"] = -17] = "NEED_SERVER_ACTIVATION";
  ERROR[ERROR["ID_NOT_FOUND"] = -18] = "ID_NOT_FOUND";
  ERROR[ERROR["ATTRIBUTE_NOT_DETECTED"] = -19] = "ATTRIBUTE_NOT_DETECTED";
  ERROR[ERROR["INSUFFICIENT_TRACKER_MEMORY_LIMIT"] = -20] = "INSUFFICIENT_TRACKER_MEMORY_LIMIT";
  ERROR[ERROR["UNKNOWN_ATTRIBUTE"] = -21] = "UNKNOWN_ATTRIBUTE";
  ERROR[ERROR["UNSUPPORTED_FILE_VERSION"] = -22] = "UNSUPPORTED_FILE_VERSION";
  ERROR[ERROR["SYNTAX_ERROR"] = -23] = "SYNTAX_ERROR";
  ERROR[ERROR["PARAMETER_NOT_FOUND"] = -24] = "PARAMETER_NOT_FOUND";
  ERROR[ERROR["INVALID_TEMPLATE"] = -25] = "INVALID_TEMPLATE";
  ERROR[ERROR["UNSUPPORTED_TEMPLATE_VERSION"] = -26] = "UNSUPPORTED_TEMPLATE_VERSION";
  ERROR[ERROR["CAMERA_INDEX_DOES_NOT_EXIST"] = -27] = "CAMERA_INDEX_DOES_NOT_EXIST";
  ERROR[ERROR["PLATFORM_NOT_LICENSED"] = -28] = "PLATFORM_NOT_LICENSED";
  ERROR[ERROR["TENSORFLOW_NOT_INITIALIZED"] = -29] = "TENSORFLOW_NOT_INITIALIZED";
  ERROR[ERROR["PLUGIN_NOT_LOADED"] = -30] = "PLUGIN_NOT_LOADED";
  ERROR[ERROR["PLUGIN_NO_PERMISSION"] = -31] = "PLUGIN_NO_PERMISSION";
  ERROR[ERROR["FACEID_NOT_FOUND"] = -32] = "FACEID_NOT_FOUND";
  ERROR[ERROR["FACEIMAGE_NOT_FOUND"] = -33] = "FACEIMAGE_NOT_FOUND";
  return ERROR;
}({});
export let IMAGEMODE = /*#__PURE__*/function (IMAGEMODE) {
  IMAGEMODE[IMAGEMODE["IMAGE_GRAYSCALE_8BIT"] = 0] = "IMAGE_GRAYSCALE_8BIT";
  IMAGEMODE[IMAGEMODE["IMAGE_COLOR_24BIT"] = 1] = "IMAGE_COLOR_24BIT";
  IMAGEMODE[IMAGEMODE["IMAGE_COLOR_32BIT"] = 2] = "IMAGE_COLOR_32BIT";
  return IMAGEMODE;
}({});
export let VIDEOCOMPRESSIONTYPE = /*#__PURE__*/function (VIDEOCOMPRESSIONTYPE) {
  VIDEOCOMPRESSIONTYPE[VIDEOCOMPRESSIONTYPE["MJPEG"] = 0] = "MJPEG";
  return VIDEOCOMPRESSIONTYPE;
}({});
export let FEATURE = /*#__PURE__*/function (FEATURE) {
  FEATURE[FEATURE["LEFT_EYE"] = 0] = "LEFT_EYE";
  FEATURE[FEATURE["RIGHT_EYE"] = 1] = "RIGHT_EYE";
  FEATURE[FEATURE["LEFT_EYE_INNER_CORNER"] = 24] = "LEFT_EYE_INNER_CORNER";
  FEATURE[FEATURE["LEFT_EYE_OUTER_CORNER"] = 23] = "LEFT_EYE_OUTER_CORNER";
  FEATURE[FEATURE["LEFT_EYE_LOWER_LINE1"] = 38] = "LEFT_EYE_LOWER_LINE1";
  FEATURE[FEATURE["LEFT_EYE_LOWER_LINE2"] = 27] = "LEFT_EYE_LOWER_LINE2";
  FEATURE[FEATURE["LEFT_EYE_LOWER_LINE3"] = 37] = "LEFT_EYE_LOWER_LINE3";
  FEATURE[FEATURE["LEFT_EYE_UPPER_LINE1"] = 35] = "LEFT_EYE_UPPER_LINE1";
  FEATURE[FEATURE["LEFT_EYE_UPPER_LINE2"] = 28] = "LEFT_EYE_UPPER_LINE2";
  FEATURE[FEATURE["LEFT_EYE_UPPER_LINE3"] = 36] = "LEFT_EYE_UPPER_LINE3";
  FEATURE[FEATURE["LEFT_EYE_LEFT_IRIS_CORNER"] = 29] = "LEFT_EYE_LEFT_IRIS_CORNER";
  FEATURE[FEATURE["LEFT_EYE_RIGHT_IRIS_CORNER"] = 30] = "LEFT_EYE_RIGHT_IRIS_CORNER";
  FEATURE[FEATURE["RIGHT_EYE_INNER_CORNER"] = 25] = "RIGHT_EYE_INNER_CORNER";
  FEATURE[FEATURE["RIGHT_EYE_OUTER_CORNER"] = 26] = "RIGHT_EYE_OUTER_CORNER";
  FEATURE[FEATURE["RIGHT_EYE_LOWER_LINE1"] = 41] = "RIGHT_EYE_LOWER_LINE1";
  FEATURE[FEATURE["RIGHT_EYE_LOWER_LINE2"] = 31] = "RIGHT_EYE_LOWER_LINE2";
  FEATURE[FEATURE["RIGHT_EYE_LOWER_LINE3"] = 42] = "RIGHT_EYE_LOWER_LINE3";
  FEATURE[FEATURE["RIGHT_EYE_UPPER_LINE1"] = 40] = "RIGHT_EYE_UPPER_LINE1";
  FEATURE[FEATURE["RIGHT_EYE_UPPER_LINE2"] = 32] = "RIGHT_EYE_UPPER_LINE2";
  FEATURE[FEATURE["RIGHT_EYE_UPPER_LINE3"] = 39] = "RIGHT_EYE_UPPER_LINE3";
  FEATURE[FEATURE["RIGHT_EYE_LEFT_IRIS_CORNER"] = 33] = "RIGHT_EYE_LEFT_IRIS_CORNER";
  FEATURE[FEATURE["RIGHT_EYE_RIGHT_IRIS_CORNER"] = 34] = "RIGHT_EYE_RIGHT_IRIS_CORNER";
  FEATURE[FEATURE["LEFT_EYEBROW_INNER_CORNER"] = 13] = "LEFT_EYEBROW_INNER_CORNER";
  FEATURE[FEATURE["LEFT_EYEBROW_MIDDLE"] = 16] = "LEFT_EYEBROW_MIDDLE";
  FEATURE[FEATURE["LEFT_EYEBROW_MIDDLE_LEFT"] = 18] = "LEFT_EYEBROW_MIDDLE_LEFT";
  FEATURE[FEATURE["LEFT_EYEBROW_MIDDLE_RIGHT"] = 19] = "LEFT_EYEBROW_MIDDLE_RIGHT";
  FEATURE[FEATURE["LEFT_EYEBROW_OUTER_CORNER"] = 12] = "LEFT_EYEBROW_OUTER_CORNER";
  FEATURE[FEATURE["RIGHT_EYEBROW_INNER_CORNER"] = 14] = "RIGHT_EYEBROW_INNER_CORNER";
  FEATURE[FEATURE["RIGHT_EYEBROW_MIDDLE"] = 17] = "RIGHT_EYEBROW_MIDDLE";
  FEATURE[FEATURE["RIGHT_EYEBROW_MIDDLE_LEFT"] = 20] = "RIGHT_EYEBROW_MIDDLE_LEFT";
  FEATURE[FEATURE["RIGHT_EYEBROW_MIDDLE_RIGHT"] = 21] = "RIGHT_EYEBROW_MIDDLE_RIGHT";
  FEATURE[FEATURE["RIGHT_EYEBROW_OUTER_CORNER"] = 15] = "RIGHT_EYEBROW_OUTER_CORNER";
  FEATURE[FEATURE["NOSE_TIP"] = 2] = "NOSE_TIP";
  FEATURE[FEATURE["NOSE_BOTTOM"] = 49] = "NOSE_BOTTOM";
  FEATURE[FEATURE["NOSE_BRIDGE"] = 22] = "NOSE_BRIDGE";
  FEATURE[FEATURE["NOSE_LEFT_WING"] = 43] = "NOSE_LEFT_WING";
  FEATURE[FEATURE["NOSE_LEFT_WING_OUTER"] = 45] = "NOSE_LEFT_WING_OUTER";
  FEATURE[FEATURE["NOSE_LEFT_WING_LOWER"] = 47] = "NOSE_LEFT_WING_LOWER";
  FEATURE[FEATURE["NOSE_RIGHT_WING"] = 44] = "NOSE_RIGHT_WING";
  FEATURE[FEATURE["NOSE_RIGHT_WING_OUTER"] = 46] = "NOSE_RIGHT_WING_OUTER";
  FEATURE[FEATURE["NOSE_RIGHT_WING_LOWER"] = 48] = "NOSE_RIGHT_WING_LOWER";
  FEATURE[FEATURE["MOUTH_RIGHT_CORNER"] = 3] = "MOUTH_RIGHT_CORNER";
  FEATURE[FEATURE["MOUTH_LEFT_CORNER"] = 4] = "MOUTH_LEFT_CORNER";
  FEATURE[FEATURE["MOUTH_TOP"] = 54] = "MOUTH_TOP";
  FEATURE[FEATURE["MOUTH_TOP_INNER"] = 61] = "MOUTH_TOP_INNER";
  FEATURE[FEATURE["MOUTH_BOTTOM"] = 55] = "MOUTH_BOTTOM";
  FEATURE[FEATURE["MOUTH_BOTTOM_INNER"] = 64] = "MOUTH_BOTTOM_INNER";
  FEATURE[FEATURE["MOUTH_LEFT_TOP"] = 56] = "MOUTH_LEFT_TOP";
  FEATURE[FEATURE["MOUTH_LEFT_TOP_INNER"] = 60] = "MOUTH_LEFT_TOP_INNER";
  FEATURE[FEATURE["MOUTH_RIGHT_TOP"] = 57] = "MOUTH_RIGHT_TOP";
  FEATURE[FEATURE["MOUTH_RIGHT_TOP_INNER"] = 62] = "MOUTH_RIGHT_TOP_INNER";
  FEATURE[FEATURE["MOUTH_LEFT_BOTTOM"] = 58] = "MOUTH_LEFT_BOTTOM";
  FEATURE[FEATURE["MOUTH_LEFT_BOTTOM_INNER"] = 63] = "MOUTH_LEFT_BOTTOM_INNER";
  FEATURE[FEATURE["MOUTH_RIGHT_BOTTOM"] = 59] = "MOUTH_RIGHT_BOTTOM";
  FEATURE[FEATURE["MOUTH_RIGHT_BOTTOM_INNER"] = 65] = "MOUTH_RIGHT_BOTTOM_INNER";
  FEATURE[FEATURE["NASOLABIAL_FOLD_LEFT_UPPER"] = 50] = "NASOLABIAL_FOLD_LEFT_UPPER";
  FEATURE[FEATURE["NASOLABIAL_FOLD_LEFT_LOWER"] = 52] = "NASOLABIAL_FOLD_LEFT_LOWER";
  FEATURE[FEATURE["NASOLABIAL_FOLD_RIGHT_UPPER"] = 51] = "NASOLABIAL_FOLD_RIGHT_UPPER";
  FEATURE[FEATURE["NASOLABIAL_FOLD_RIGHT_LOWER"] = 53] = "NASOLABIAL_FOLD_RIGHT_LOWER";
  FEATURE[FEATURE["CHIN_BOTTOM"] = 11] = "CHIN_BOTTOM";
  FEATURE[FEATURE["CHIN_LEFT"] = 9] = "CHIN_LEFT";
  FEATURE[FEATURE["CHIN_RIGHT"] = 10] = "CHIN_RIGHT";
  FEATURE[FEATURE["FACE_CONTOUR1"] = 7] = "FACE_CONTOUR1";
  FEATURE[FEATURE["FACE_CONTOUR2"] = 5] = "FACE_CONTOUR2";
  FEATURE[FEATURE["FACE_CONTOUR12"] = 6] = "FACE_CONTOUR12";
  FEATURE[FEATURE["FACE_CONTOUR13"] = 8] = "FACE_CONTOUR13";
  FEATURE[FEATURE["FACE_CONTOUR14"] = 66] = "FACE_CONTOUR14";
  FEATURE[FEATURE["FACE_CONTOUR15"] = 67] = "FACE_CONTOUR15";
  FEATURE[FEATURE["FACE_CONTOUR16"] = 68] = "FACE_CONTOUR16";
  FEATURE[FEATURE["FACE_CONTOUR17"] = 69] = "FACE_CONTOUR17";
  return FEATURE;
}({});

/**
 * Error handling behavior.
 * @enum {number}
 */
export let ON_ERROR = /*#__PURE__*/function (ON_ERROR) {
  /** Return an "invalid" value on error (i.e. invalid Image if image creation is failed). */
  ON_ERROR[ON_ERROR["SILENT"] = 0] = "SILENT";
  /** Like SILENT, but also show a React Native alert window. */
  ON_ERROR[ON_ERROR["ALERT"] = 1] = "ALERT";
  /** Raise an FSDKEroor on error. */
  ON_ERROR[ON_ERROR["THROW"] = 2] = "THROW";
  return ON_ERROR;
}({});
export class FSDKError extends Error {
  constructor(message, errorCode, readonly) {
    super(message);
    this.errorCode = errorCode;
    this.readonly = readonly;
  }
}
const CONSTANTS = LuxandFaceSDK.getConstants();
export const FACIAL_FEATURE_COUNT = Object.keys(CONSTANTS.FEATURE).length;
function checkMatchingEnums(enum_, values) {
  const enumKeys = Object.keys(enum_).filter(key => isNaN(Number(key)));
  const keys = Object.keys(values);
  const missingKeys = keys.filter(item => !enumKeys.includes(item));
  const extraKeys = enumKeys.filter(item => !keys.includes(item));
  if (missingKeys.length > 0 || extraKeys.length > 0) {
    console.warn(`FSDK: items missmatch in ${enum_.name}. Missing keys: ${JSON.stringify(missingKeys)}. Extra keys: ${JSON.stringify(extraKeys)}`);
    return;
  }
  for (const key of enumKeys) if (enum_[key] !== values[key]) console.warn(`FSDK: items missmatch in ${enum_.name}. ${enum_[key]} != ${values[key]} for ${key}.`);
}
checkMatchingEnums(ERROR, CONSTANTS.ERROR);
checkMatchingEnums(IMAGEMODE, CONSTANTS.IMAGEMODE);
checkMatchingEnums(VIDEOCOMPRESSIONTYPE, CONSTANTS.VIDEOCOMPRESSIONTYPE);
checkMatchingEnums(FEATURE, CONSTANTS.FEATURE);
//# sourceMappingURL=definitions.js.map