"use strict";

import { Platform, TurboModuleRegistry } from 'react-native';
import RNFS from 'react-native-fs';
export default TurboModuleRegistry.getEnforcing('LuxandFaceSDK');
export async function copyAssetsToCacheDirectory() {
  const sourceDir = Platform.OS == 'android' ? 'data' : RNFS.MainBundlePath + '/data';
  const destDir = RNFS.CachesDirectoryPath + '/data';
  const destDirExists = await RNFS.exists(destDir);
  if (!destDirExists) await RNFS.mkdir(destDir);
  await copyDirectory(sourceDir, destDir);
}
;
async function copyDirectory(source, destination) {
  const files = Platform.OS == 'android' ? await RNFS.readDirAssets(source) : await RNFS.readDir(source);
  for (const file of files) {
    const sourcePath = file.path;
    const destPath = destination + '/' + file.name;
    if (file.isFile()) {
      if (await RNFS.exists(destPath)) continue;
      if (Platform.OS === 'android') await RNFS.copyFileAssets(sourcePath, destPath);else await RNFS.copyFile(sourcePath, destPath);
    } else if (file.isDirectory()) {
      if (!(await RNFS.exists(destPath))) await RNFS.mkdir(destPath);
      await copyDirectory(sourcePath, destPath);
    }
  }
}
//# sourceMappingURL=NativeFaceSDK.js.map