"use strict";

import { Alert } from 'react-native';
import LuxandFaceSDK from "./NativeFaceSDK.js";
import { ERROR, ON_ERROR } from "./definitions.js";
import { getParametersString } from "./utils.js";
import { VisionCameraProxy } from 'react-native-vision-camera';
import { Worklets } from 'react-native-worklets-core';
var alert;
if (Worklets !== undefined) alert = Worklets.createRunOnJS(msg => Alert.alert('FaceSDK Error', msg));
var onError;
if (Worklets !== undefined) onError = Worklets.createSharedValue(ON_ERROR.THROW);
function executeSDKFunction(func, funcName, processor, ...args) {
  'worklet';

  const result = func(...args);
  const errorCode = result.errorCode;
  if (errorCode === ERROR.OK) return processor(result.result);
  if (onError.value == ON_ERROR.SILENT) return processor === returnErrorPosition ? processor(result.result) : processor();
  var msg = `Fuction FSDK.${funcName} failed with error ${result.error}: ${errorCode}.\nArguments were ${JSON.stringify(args)}.\nResult was ${JSON.stringify(result.result)}`;
  if (errorCode == -2) msg += '\nPlease call FSDK.ActivateLibrary(yourLicenseKey) before using any other function.';
  if (onError.value == ON_ERROR.ALERT) {
    alert(msg);
    return processor === returnErrorPosition ? processor(result.result) : processor();
  }
  if (onError.value == ON_ERROR.THROW) throw new Error(msg);
  throw new Error(`Unknown ON_ERROR value ${onError.value}`);
}
function returnVoid(_ = {}) {
  'worklet';

  return;
}
function returnFaceImage(result = {
  value: {
    image: -1,
    features: []
  }
}) {
  'worklet';

  return {
    image: result.value.image,
    features: result.value.features
  };
}
function returnDefault(defaultValue) {
  return result => {
    'worklet';

    if (result === null || result === undefined) return defaultValue;
    return result.value;
  };
}
const emptyPoint = {
  x: 0,
  y: 0
};
const emptyFacePosition = {
  xc: 0,
  yc: 0,
  w: 0,
  angle: 0
};
const emptyFace = {
  bbox: {
    p0: emptyPoint,
    p1: emptyPoint
  },
  features: Array(5).fill(emptyPoint)
};
const emptyTrackerID = {
  id: -1,
  faceID: -1
};
const returnZero = returnDefault(0);
const returnNegativeOne = returnDefault(-1);
const returnEmptyString = returnDefault('');
const returnFacePosition = returnDefault(emptyFacePosition);
const returnFacePositions = returnDefault([]);
const returnFace = returnDefault(emptyFace);
const returnFaces = returnDefault([]);
const returnFeatures = returnDefault([]);
const returnIDs = returnDefault([]);
const returnTrackerID = returnDefault(emptyTrackerID);
const returnIDSimilarities = returnDefault([]);
const returnErrorPosition = returnDefault(0);
var frameToFSDKImagePlugin;
if (VisionCameraProxy !== undefined) frameToFSDKImagePlugin = VisionCameraProxy.initFrameProcessorPlugin('frameToFSDKImage', {});
export function frameToFSDKImage(frame) {
  'worklet';

  if (frameToFSDKImagePlugin === undefined) return {
    error: 'Could not load frameToFSDKImage plugin',
    errorCode: 1,
    result: {
      value: -1
    }
  };
  const result = frameToFSDKImagePlugin.call(frame);
  if (result === undefined || typeof result === 'number' || typeof result === 'string' || typeof result === 'boolean' || result instanceof ArrayBuffer || result instanceof Array) return {
    error: `Unsupported value returned from FrameToFSDKImage plugin: ${JSON.stringify(result)}`,
    errorCode: 1,
    result: {
      value: -1
    }
  };
  const error = result['error'];
  if (typeof error !== 'string') return {
    error: `Unsupported value returned for 'error' from FrameToFSDKImage plugin: ${JSON.stringify(error)}`,
    errorCode: 1,
    result: {
      value: -1
    }
  };
  const errorCode = result['errorCode'];
  if (typeof errorCode !== 'number') return {
    error: `Unsupported value returned for 'errorCode' from FrameToFSDKImage plugin: ${JSON.stringify(error)}`,
    errorCode: 1,
    result: {
      value: -1
    }
  };
  const handle = result['handle'];
  if (typeof handle !== 'number') return {
    error: `Unsupported value returned for 'handle' from FrameToFSDKImage plugin: ${JSON.stringify(error)}`,
    errorCode: 1,
    result: {
      value: -1
    }
  };
  return {
    error: error,
    errorCode: errorCode,
    result: {
      value: handle
    }
  };
}
export default class FSDK {
  static SetOnError(value) {
    onError.value = value;
  }
  static ActivateLibrary(licenseKey) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.ActivateLibrary, 'ActivateLibrary', returnVoid, licenseKey);
  }
  static Initialize() {
    'worklet';

    LuxandFaceSDK.SetParameter('environment', 'reactnative');
    return executeSDKFunction(LuxandFaceSDK.Initialize, 'Initialize', returnVoid);
  }
  static ActivateAndInitalize(licenseKey) {
    'worklet';

    this.ActivateLibrary(licenseKey);
    return this.Initialize();
  }
  static GetLicenseInfo() {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetLicenseInfo, 'GetLicenseInfo', returnEmptyString);
  }
  static GetVersionInfo() {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetVersionInfo, 'GetVersionInfo', returnEmptyString);
  }
  static CreateEmptyImage() {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.CreateEmptyImage, 'CreateEmptyImage', returnNegativeOne);
  }
  static FreeImage(image) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.FreeImage, 'FreeImage', returnVoid, image);
  }
  static LoadImageFromFile(filename) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.LoadImageFromFile, 'LoadImageFromFile', returnNegativeOne, filename);
  }
  static LoadImageFromFileWithAlpha(filename) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.LoadImageFromFileWithAlpha, 'LoadImageFromFileWithAlpha', returnNegativeOne, filename);
  }
  static LoadImageFromBuffer(buffer, width, height, scanLine, imageMode) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.LoadImageFromBuffer, 'LoadImageFromBuffer', returnNegativeOne, buffer, width, height, scanLine, imageMode);
  }
  static LoadImageFromJpegBuffer(buffer) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.LoadImageFromJpegBuffer, 'LoadImageFromJpegBuffer', returnNegativeOne, buffer);
  }
  static LoadImageFromPngBuffer(buffer) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.LoadImageFromPngBuffer, 'LoadImageFromPngBuffer', returnNegativeOne, buffer);
  }
  static LoadImageFromPngBufferWithAlpha(buffer) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.LoadImageFromPngBufferWithAlpha, 'LoadImageFromPngBufferWithAlpha', returnNegativeOne, buffer);
  }
  static LoadImageFromFrame(frame) {
    'worklet';

    return executeSDKFunction(frameToFSDKImage, 'frameToFSDKImage', returnNegativeOne, frame);
  }
  static SaveImageToFile(image, filename) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SaveImageToFile, 'SaveImageToFile', returnVoid, filename, image);
  }
  static SetJpegCompressionQuality(quality) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SetJpegCompressionQuality, 'SetJpegCompressionQuality', returnVoid, quality);
  }
  static GetImageWidth(image) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetImageWidth, 'GetImageWidth', returnZero, image);
  }
  static GetImageHeight(image) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetImageHeight, 'GetImageHeight', returnZero, image);
  }
  static GetImageBufferSize(image, imageMode) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetImageBufferSize, 'GetImageBufferSize', returnZero, image, imageMode);
  }
  static SaveImageToBuffer(image, imageMode) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SaveImageToBuffer, 'SaveImageToBuffer', returnEmptyString, image, imageMode, this.GetImageBufferSize(image, imageMode));
  }
  static CopyImage(image) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.CopyImage, 'CopyImage', returnNegativeOne, image);
  }
  static ResizeImage(image, ratio) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.ResizeImage, 'ResizeImage', returnNegativeOne, image, ratio);
  }
  static RotateImage90(image, multiplier) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.RotateImage90, 'RotateImage90', returnNegativeOne, image, multiplier);
  }
  static RotateImage(image, angle) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.RotateImage, 'RotateImage', returnNegativeOne, image, angle);
  }
  static RotateImageCenter(image, angle, x, y) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.RotateImageCenter, 'RotateImageCenter', returnNegativeOne, image, angle, x, y);
  }
  static CopyRect(image, x1, y1, x2, y2) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.CopyRect, 'CopyRect', returnNegativeOne, image, x1, y1, x2, y2);
  }
  static CopyRectReplicateBorder(image, x1, y1, x2, y2) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.CopyRectReplicateBorder, 'CopyRectReplicateBorder', returnNegativeOne, image, x1, y1, x2, y2);
  }
  static MirrorImage(image, vertical = true) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.MirrorImage, 'MirrorImage', returnVoid, image, vertical);
  }
  static ExtractFaceImage(image, features, width, height) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.ExtractFaceImage, 'ExtractFaceImage', returnFaceImage, image, features, width, height);
  }
  static DetectFace(image) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.DetectFace, 'DetectFace', returnFacePosition, image);
  }
  static DetectMultipleFaces(image, maxFaces = 100) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.DetectMultipleFaces, 'DetectMultipleFaces', returnFacePositions, image, maxFaces);
  }
  static SetFaceDetectionParameters(handleArbitraryRotations, determineFaceRotationAngle, internalResizeWidth) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SetFaceDetectionParameters, 'SetFaceDetectionParameters', returnVoid, handleArbitraryRotations, determineFaceRotationAngle, internalResizeWidth);
  }
  static SetFaceDetectionThreshold(threshold) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SetFaceDetectionThreshold, 'SetFaceDetectionThreshold', returnVoid, threshold);
  }
  static GetDetectedFaceConfidence() {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetDetectedFaceConfidence, 'GetDetectedFaceConfidence', returnZero);
  }
  static DetectFacialFeatures(image) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.DetectFacialFeatures, 'DetectFacialFeatures', returnFeatures, image);
  }
  static DetectFacialFeaturesInRegion(image, position) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.DetectFacialFeaturesInRegion, 'DetectFacialFeaturesInRegion', returnFeatures, image, position);
  }
  static DetectEyes(image) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.DetectEyes, 'DetectEyes', returnFeatures, image);
  }
  static DetectEyesInRegion(image, position) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.DetectEyesInRegion, 'DetectEyesInRegion', returnFeatures, image, position);
  }
  static GetFaceTemplate(image) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetFaceTemplate, 'GetFaceTemplate', returnEmptyString, image);
  }
  static GetFaceTemplateInRegion(image, position) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetFaceTemplateInRegion, 'GetFaceTemplateInRegion', returnEmptyString, image, position);
  }
  static GetFaceTemplateUsingFeatures(image, features) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetFaceTemplateUsingFeatures, 'GetFaceTemplateUsingFeatures', returnEmptyString, image, features);
  }
  static GetFaceTemplateUsingEyes(image, eyes) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetFaceTemplateUsingEyes, 'GetFaceTemplateUsingEyes', returnEmptyString, image, eyes);
  }
  static MatchFaces(template1, template2) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.MatchFaces, 'MatchFaces', returnZero, template1, template2);
  }
  static GetMatchingThresholdAtFAR(far) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetMatchingThresholdAtFAR, 'GetMatchingThresholdAtFAR', returnZero, far);
  }
  static GetMatchingThresholdAtFRR(frr) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetMatchingThresholdAtFRR, 'GetMatchingThresholdAtFRR', returnZero, frr);
  }
  static CreatTracker() {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.CreateTracker, 'CreateTracker', returnNegativeOne);
  }
  static LoadTrackerMemoryFromFile(filename) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.LoadTrackerMemoryFromFile, 'LoadTrackerMemoryFromFile', returnNegativeOne, filename);
  }
  static LoadTrackerMemoryFromBuffer(buffer) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.LoadTrackerMemoryFromBuffer, 'LoadTrackerMemoryFromBuffer', returnNegativeOne, buffer);
  }
  static FreeTracker(tracker) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.FreeTracker, 'FreeTracker', returnVoid, tracker);
  }
  static ClearTracker(tracker) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.ClearTracker, 'ClearTracker', returnVoid, tracker);
  }
  static SaveTrackerMemoryToFile(tracker, filename) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SaveTrackerMemoryToFile, 'SaveTrackerMemoryToFile', returnVoid, tracker, filename);
  }
  static GetTrackerMemoryBufferSize(tracker) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerMemoryBufferSize, 'GetTrackerMemoryBufferSize', returnZero, tracker);
  }
  static SaveTrackerMemoryToBuffer(tracker) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SaveTrackerMemoryToBuffer, 'SaveTrackerMemoryToBuffer', returnEmptyString, tracker, this.GetTrackerMemoryBufferSize(tracker));
  }
  static SetTrackerParameter(tracker, name, value) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SetTrackerParameter, 'SetTrackerParameter', returnVoid, tracker, name, value.toString());
  }
  static SetTrackerMultipleParameters(tracker, parameters) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SetTrackerMultipleParameters, 'SetTrackerMultipleParameters', returnNegativeOne, tracker, getParametersString(parameters));
  }
  static GetTrackerParameter(tracker, name, maxSize = 100) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerParameter, 'GetTrackerParameter', returnEmptyString, tracker, name, maxSize);
  }
  static FeedFrame(tracker, image, maxFaces = 256, index = 0) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.FeedFrame, 'FeedFrame', returnIDs, tracker, index, image, maxFaces);
  }
  static GetTrackerEyes(tracker, id, index = 0) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerEyes, 'GetTrackerEyes', returnFeatures, tracker, index, id);
  }
  static GetTrackerFacialFeatures(tracker, id, index = 0) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerFacialFeatures, 'GetTrackerFacialFeatures', returnFeatures, tracker, index, id);
  }
  static GetTrackerFacePosition(tracker, id, index = 0) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerFacePosition, 'GetTrackerFacePosition', returnFacePosition, tracker, index, id);
  }
  static LockID(tracker, id) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.LockID, 'LockID', returnVoid, tracker, id);
  }
  static UnlockID(tracker, id) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.UnlockID, 'UnlockID', returnVoid, tracker, id);
  }
  static PurgeID(tracker, id) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.PurgeID, 'PurgeID', returnVoid, tracker, id);
  }
  static SetName(tracker, id, name) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SetName, 'SetName', returnVoid, tracker, id, name);
  }
  static GetName(tracker, id, maxSize = 256) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetName, 'GetName', returnEmptyString, tracker, id, maxSize);
  }
  static GetAllNames(tracker, id, maxSize = 256) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetAllNames, 'GetAllNames', returnEmptyString, tracker, id, maxSize);
  }
  static GetIDReassignment(tracker, id) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetIDReassignment, 'GetIDReassignment', returnNegativeOne, tracker, id);
  }
  static GetSimilarIDCount(tracker, id) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetSimilarIDCount, 'GetSimilarIDCount', returnZero, tracker, id);
  }
  static GetSimilarIDList(tracker, id) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetSimilarIDList, 'GetSimilarIDList', returnIDs, tracker, id, this.GetSimilarIDCount(tracker, id));
  }
  static GetTrackerIDsCount(tracker) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerIDsCount, 'GetTrackerIDsCount', returnZero, tracker);
  }
  static GetTrackerAllIDs(tracker) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerAllIDs, 'GetTrackerAllIDs', returnIDs, tracker, this.GetTrackerIDsCount(tracker));
  }
  static GetTrackerFaceIDsCountForID(tracker, id) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerFaceIDsCountForID, 'GetTrackerFaceIDsCountForID', returnZero, tracker, id);
  }
  static GetTrackerFaceIDsForID(tracker, id) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerFaceIDsForID, 'GetTrackerFaceIDsForID', returnIDs, tracker, id, this.GetTrackerFaceIDsCountForID(tracker, id));
  }
  static GetTrackerIDByFaceID(tracker, faceID) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerIDByFaceID, 'GetTrackerIDByFaceID', returnNegativeOne, tracker, faceID);
  }
  static GetTrackerFaceTemplate(tracker, faceID) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerFaceTemplate, 'GetTrackerFaceTemplate', returnEmptyString, tracker, faceID);
  }
  static GetTrackerFaceImage(tracker, faceID) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerFaceImage, 'GetTrackerFaceImage', returnNegativeOne, tracker, faceID);
  }
  static SetTrackerFaceImage(tracker, faceID, image) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SetTrackerFaceImage, 'SetTrackerFaceImage', returnVoid, tracker, faceID, image);
  }
  static DeleteTrackerFaceImage(tracker, faceID) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.DeleteTrackerFaceImage, 'DeleteTrackerFaceImage', returnVoid, tracker, faceID);
  }
  static TrackerCreateID(tracker, template) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.TrackerCreateID, 'TrackerCreateID', returnTrackerID, tracker, template);
  }
  static AddTrackerFaceTemplate(tracker, id, template) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.AddTrackerFaceTemplate, 'AddTrackerFaceTemplate', returnVoid, tracker, id, template);
  }
  static DeleteTrackerFace(tracker, faceID) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.DeleteTrackerFace, 'DeleteTrackerFace', returnVoid, tracker, faceID);
  }
  static TrackerMatchFaces(tracker, template, threshold, maxSize = 256) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.TrackerMatchFaces, 'TrackerMatchFaces', returnIDSimilarities, tracker, template, threshold, maxSize);
  }
  static GetTrackerFacialAttribute(tracker, id, attribute, maxSize = 256, index = 0) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetTrackerFacialAttribute, 'GetTrackerFacialAttribute', returnEmptyString, tracker, index, id, attribute instanceof Array ? attribute.join(';') : attribute, maxSize);
  }
  static DetectFacialAttributeUsingFeatures(image, features, attribute, maxSize = 256) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.DetectFacialAttributeUsingFeatures, 'DetectFacialAttributeUsingFeatures', returnEmptyString, image, features, attribute instanceof Array ? attribute.join(';') : attribute, maxSize);
  }
  static GetValueConfidence(values, value) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GetValueConfidence, 'GetValueConfidence', returnZero, values, value);
  }
  static SetParameter(name, value) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SetParameter, 'SetParameter', returnVoid, name, value.toString());
  }
  static SetParameters(parameters) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SetParameters, 'SetParameters', returnVoid, getParametersString(parameters));
  }
  static SetHTTPProxy(address, port, username, password) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.SetHTTPProxy, 'SetHTTPProxy', returnVoid, address, port, username, password);
  }
  static OpenIPVideoCamera(comression, url, username, password, timeout) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.OpenIPVideoCamera, 'OpenIPVideoCamera', returnNegativeOne, comression, url, username, password, timeout);
  }
  static InitializeCapturing() {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.InitializeCapturing, 'InitializeCapturing', returnVoid);
  }
  static FinalizeCapturing() {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.FinalizeCapturing, 'FinalizeCapturing', returnVoid);
  }
  static GrabFrame(camera) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.GrabFrame, 'GrabFrame', returnNegativeOne, camera);
  }
  static CloseVideoCamera(camera) {
    'worklet';

    return executeSDKFunction(LuxandFaceSDK.CloseVideoCamera, 'CloseVideoCamera', returnVoid, camera);
  }
}
//# sourceMappingURL=FaceSDKWorklets.js.map