import fsdk
import sys, os.path

from fsdk import FSDK

def main():
    
    if len(sys.argv)==1:
        print("Usage: check_liveness.py <imagefile>\n")
        exit(1)

    try: 
        FSDK.ActivateLibrary("INSERT THE LICENSE KEY HERE")
    except:
        print("Luxand FaceSDK activation error")
        exit(1)
    
    FSDK.Initialize()
    FSDK.SetFaceDetectionParameters(False, False, 320)

    try: 
        FSDK.SetParameter("LivenessModel", "external")
    except Exception as e: 
        print("Couldn't initialize external liveness model ", e)
        exit(1)

    try:
        img = FSDK.Image(sys.argv[1])
        features = img.DetectFacialFeatures()
        facialAttributes = img.DetectFacialAttributeUsingFeatures(features, "Liveness")
        img.Free()
        
        err = facialAttributes.find("LivenessError")
        if (err != -1):
            print("Error checking liveness:", facialAttributes[err + 14:])
        else:
            liveness = FSDK.GetValueConfidence(facialAttributes, "Liveness")
            print("Liveness score:", liveness)

            if (facialAttributes.find("ImageQuality") != -1):
                image_quality = FSDK.GetValueConfidence(facialAttributes, "ImageQuality")
                print("Image quality:", image_quality)

    except Exception as e:
        print("Error: ", e)
        exit(1)

main()