/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.idliveface.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.idrnd.idliveface.Validation;

public class Helper {
    private static final Validation[] VALIDATION_VALUES = Validation.values();
    public static final NativeLibrary NATIVE_LIBRARY = new NativeLibrary();

    private Helper() {
    }

    public static Set<Validation> createValidationSet(int[] ordinals) {
        return Collections.unmodifiableSet(Arrays.stream(ordinals).mapToObj(i -> VALIDATION_VALUES[i]).collect(Collectors.toCollection(() -> EnumSet.noneOf(Validation.class))));
    }

    public static <T> List<T> wrapArray(T[] array) {
        return Collections.unmodifiableList(Arrays.asList(array));
    }

    public static String[] flattenStringMap(Map<String, String> map) {
        String[] array = new String[map.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            array[i++] = entry.getKey();
            array[i++] = entry.getValue();
        }
        return array;
    }

    public static ToStringGenerator toStringGenerator(Object caller) {
        return new ToStringGenerator(caller.getClass());
    }

    public static class ToStringGenerator {
        private static final String GLUE = ", ";
        private final StringBuilder builder = new StringBuilder();

        private ToStringGenerator(Class<?> classObj) {
            this.builder.append(classObj.getSimpleName()).append('(');
        }

        public ToStringGenerator field(String name, Object value) {
            this.builder.append(name).append('=').append(value).append(GLUE);
            return this;
        }

        public ToStringGenerator field(String name, float value) {
            this.builder.append(name).append('=').append(value).append(GLUE);
            return this;
        }

        public ToStringGenerator field(String name, int value) {
            this.builder.append(name).append('=').append(value).append(GLUE);
            return this;
        }

        public String generate() {
            this.builder.setLength(this.builder.length() - GLUE.length());
            this.builder.append(')');
            return this.builder.toString();
        }
    }

    public static class NativeLibrary {
        private NativeLibrary() {
            System.loadLibrary("idliveface");
        }
    }
}

