/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.idliveface.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.idrnd.idliveface.Blueprint;
import net.idrnd.idliveface.IDLiveFaceException;
import net.idrnd.idliveface.ReleaseInfo;
import net.idrnd.idliveface.RuntimeConfiguration;

public class AndroidSupport {
    private static final String PREF_ASSETS_VERSION = "assets-version";
    private static final String INIT_DATA_DIR = "data";

    private AndroidSupport() {
    }

    public static Blueprint createBlueprint(Context context) {
        return new Blueprint(AndroidSupport.copyInitData(context));
    }

    public static Blueprint createBlueprint(Context context, RuntimeConfiguration runtimeConfig) {
        return new Blueprint(AndroidSupport.copyInitData(context), Objects.requireNonNull(runtimeConfig));
    }

    private static File copyInitData(Context context) {
        Objects.requireNonNull(context);
        SharedPreferences prefs = context.getSharedPreferences("idliveface", 0);
        File initDataDir = new File(context.getFilesDir(), INIT_DATA_DIR);
        String extractedVersion = prefs.getString(PREF_ASSETS_VERSION, null);
        String currentVersion = ReleaseInfo.getReleaseInfo().getVersion();
        if (initDataDir.exists() && currentVersion.equals(extractedVersion)) {
            return initDataDir;
        }
        try {
            if (initDataDir.exists()) {
                AndroidSupport.deleteFile(initDataDir);
            }
            AndroidSupport.copyAssets(context);
        }
        catch (IOException e) {
            throw new IDLiveFaceException("Failed to copy assets: " + e.getMessage(), e);
        }
        prefs.edit().putString(PREF_ASSETS_VERSION, currentVersion).apply();
        return initDataDir;
    }

    private static void deleteFile(File file) throws IOException {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                AndroidSupport.deleteFile(child);
            }
        }
        file.delete();
    }

    private static void copyAssets(Context context) throws IOException {
        AssetManager assetManager = context.getAssets();
        File filesDir = context.getFilesDir();
        byte[] buffer = new byte[8192];
        for (String asset : AndroidSupport.listAssets(assetManager)) {
            File target = new File(filesDir, asset);
            target.getParentFile().mkdirs();
            InputStream in = assetManager.open(asset);
            Throwable throwable = null;
            try {
                FileOutputStream out = new FileOutputStream(target);
                Throwable throwable2 = null;
                try {
                    int read;
                    while ((read = in.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, read);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (out == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    private static List<String> listAssets(AssetManager assetManager) throws IOException {
        ArrayList<String> assetPaths = new ArrayList<String>();
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(INIT_DATA_DIR);
        while (!queue.isEmpty()) {
            String path = (String)queue.remove();
            String[] assets = assetManager.list(path);
            if (assets.length == 0) {
                assetPaths.add(path);
                continue;
            }
            for (String asset : assets) {
                queue.add(path + "/" + asset);
            }
        }
        return assetPaths;
    }
}

