/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.idliveface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.idrnd.idliveface.util.Helper;

public class RuntimeConfiguration {
    private static final Object lib = Helper.NATIVE_LIBRARY;
    private int workerThreads;
    private int backendThreads;
    private int backendInvocations;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public RuntimeConfiguration() {
        this(0);
    }

    public RuntimeConfiguration(int effectiveCpuCores) {
        this.init(effectiveCpuCores);
    }

    private native void init(int var1);

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public RuntimeConfiguration setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    public int getBackendThreads() {
        return this.backendThreads;
    }

    public RuntimeConfiguration setBackendThreads(int backendThreads) {
        this.backendThreads = backendThreads;
        return this;
    }

    public int getBackendInvocations() {
        return this.backendInvocations;
    }

    public RuntimeConfiguration setBackendInvocations(int backendInvocations) {
        this.backendInvocations = backendInvocations;
        return this;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public RuntimeConfiguration setParameter(String name, String value) {
        this.parameters.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
        return this;
    }

    public String toString() {
        return Helper.toStringGenerator(this).field("workerThreads", this.workerThreads).field("backendThreads", this.backendThreads).field("backendInvocations", this.backendInvocations).field("parameters", this.parameters).generate();
    }
}

