/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.idliveface;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Objects;
import net.idrnd.idliveface.Image;
import net.idrnd.idliveface.NativeObject;

public class ImageDecoder
extends NativeObject {
    ImageDecoder(long address) {
        super(address);
    }

    @Override
    protected native void release();

    public Image decodeFile(File filePath) {
        return this.decodeFile(Objects.requireNonNull(filePath).toString());
    }

    public Image decodeFile(Path filePath) {
        return this.decodeFile(Objects.requireNonNull(filePath).toString());
    }

    public Image decodeFile(String filePath) {
        return this.decodeFileInternal(Objects.requireNonNull(filePath));
    }

    private native Image decodeFileInternal(String var1);

    public Image decode(byte[] bytes) {
        return this.decodeBytesInternal(Objects.requireNonNull(bytes));
    }

    private native Image decodeBytesInternal(byte[] var1);

    public Image decode(ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        return buffer.isDirect() ? this.decodeByteBufferInternal(buffer, buffer.limit()) : this.decodeBytesInternal(buffer.array());
    }

    private native Image decodeByteBufferInternal(ByteBuffer var1, int var2);
}

