/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.idliveface;

import java.nio.ByteBuffer;
import java.util.Objects;
import net.idrnd.idliveface.ImageAttributes;
import net.idrnd.idliveface.NativeObject;
import net.idrnd.idliveface.PixelFormat;

public class Image
extends NativeObject {
    Image(long address) {
        super(address);
    }

    public Image(byte[] pixels, int width, int height, PixelFormat pixelFormat) {
        super(Image.validateAndInit(pixels, width, height, pixelFormat));
    }

    public Image(ByteBuffer pixels, int width, int height, PixelFormat pixelFormat) {
        super(Image.validateAndInit(pixels, width, height, pixelFormat));
    }

    private static long validateAndInit(byte[] pixels, int width, int height, PixelFormat pixelFormat) {
        Objects.requireNonNull(pixels);
        Objects.requireNonNull(pixelFormat);
        Image.checkNumberOfPixels(pixels.length, width, height, pixelFormat);
        return Image.initBytes(pixels, width, height, pixelFormat);
    }

    private static long validateAndInit(ByteBuffer pixels, int width, int height, PixelFormat pixelFormat) {
        Objects.requireNonNull(pixels);
        Objects.requireNonNull(pixelFormat);
        Image.checkNumberOfPixels(pixels.limit(), width, height, pixelFormat);
        return pixels.isDirect() ? Image.initByteBuffer(pixels, width, height, pixelFormat) : Image.initBytes(pixels.array(), width, height, pixelFormat);
    }

    private static void checkNumberOfPixels(long numberOfPixels, int width, int height, PixelFormat pixelFormat) {
        int channels;
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be a positive number");
        }
        int n = channels = pixelFormat == PixelFormat.GRAYSCALE ? 1 : 3;
        if (numberOfPixels != (long)(width * height * channels)) {
            throw new IllegalArgumentException("Number of pixels does not match width/height/pixelFormat");
        }
    }

    private static native long initBytes(byte[] var0, int var1, int var2, PixelFormat var3);

    private static native long initByteBuffer(ByteBuffer var0, int var1, int var2, PixelFormat var3);

    @Override
    protected native void release();

    public native ImageAttributes getAttributes();
}

