/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.idliveface;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.idrnd.idliveface.DetectedFace;
import net.idrnd.idliveface.ImageQualityAttributes;
import net.idrnd.idliveface.Validation;
import net.idrnd.idliveface.util.Helper;

public class FaceDetectionResult {
    private final List<DetectedFace> faces;
    private final ImageQualityAttributes imageQualityAttributes;
    private final Set<Validation> failedValidations;

    FaceDetectionResult(DetectedFace[] faces, ImageQualityAttributes imageQualityAttributes, int[] failedValidationOrdinals) {
        this.faces = Helper.wrapArray(faces);
        this.imageQualityAttributes = Objects.requireNonNull(imageQualityAttributes);
        this.failedValidations = Helper.createValidationSet(failedValidationOrdinals);
    }

    public List<DetectedFace> getFaces() {
        return this.faces;
    }

    public ImageQualityAttributes getImageQualityAttributes() {
        return this.imageQualityAttributes;
    }

    public Set<Validation> getFailedValidations() {
        return this.failedValidations;
    }

    public String toString() {
        return Helper.toStringGenerator(this).field("faces", this.faces).field("imageQualityAttributes", this.imageQualityAttributes).field("failedValidations", this.failedValidations).generate();
    }
}

