/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.idliveface;

import java.util.List;
import java.util.Objects;
import net.idrnd.idliveface.BoundingBox;
import net.idrnd.idliveface.HeadPose;
import net.idrnd.idliveface.Point;
import net.idrnd.idliveface.util.Helper;

public class FaceAttributes {
    private final BoundingBox box;
    private final List<Point> landmarks;
    private final HeadPose headPose;
    private final int orientation;
    private final int pupillaryDistance;
    private final float occlusion;
    private final float eyesClosed;

    FaceAttributes(BoundingBox box, Point[] landmarks, HeadPose headPose, int orientation, int pupillaryDistance, float occlusion, float eyesClosed) {
        this.box = Objects.requireNonNull(box);
        this.landmarks = Helper.wrapArray(landmarks);
        this.headPose = Objects.requireNonNull(headPose);
        this.orientation = orientation;
        this.pupillaryDistance = pupillaryDistance;
        this.occlusion = occlusion;
        this.eyesClosed = eyesClosed;
    }

    public BoundingBox getBox() {
        return this.box;
    }

    public List<Point> getLandmarks() {
        return this.landmarks;
    }

    public HeadPose getHeadPose() {
        return this.headPose;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getPupillaryDistance() {
        return this.pupillaryDistance;
    }

    public float getOcclusion() {
        return this.occlusion;
    }

    public float getEyesClosed() {
        return this.eyesClosed;
    }

    public String toString() {
        return Helper.toStringGenerator(this).field("box", this.box).field("headPose", this.headPose).field("orientation", this.orientation).field("pupillaryDistance", this.pupillaryDistance).field("occlusion", this.occlusion).field("eyesClosed", this.eyesClosed).field("landmarks", this.landmarks).generate();
    }
}

