/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.idliveface;

import java.util.Optional;
import java.util.Set;
import net.idrnd.idliveface.BoundingBox;
import net.idrnd.idliveface.FaceStatus;
import net.idrnd.idliveface.Validation;
import net.idrnd.idliveface.util.Helper;

public class FaceAnalysisResult {
    private static final FaceStatus[] FACE_STATUS_VALUES = FaceStatus.values();
    private final FaceStatus status;
    private final Float genuineProbability;
    private final BoundingBox box;
    private final Set<Validation> failedValidations;

    protected FaceAnalysisResult(int statusOrdinal, Float genuineProbability, BoundingBox box, int[] failedValidationOrdinals) {
        this.status = FACE_STATUS_VALUES[statusOrdinal];
        this.genuineProbability = genuineProbability;
        this.box = box;
        this.failedValidations = Helper.createValidationSet(failedValidationOrdinals);
    }

    public FaceStatus getStatus() {
        return this.status;
    }

    public Optional<Float> getGenuineProbability() {
        return Optional.ofNullable(this.genuineProbability);
    }

    public Optional<BoundingBox> getBox() {
        return Optional.ofNullable(this.box);
    }

    public Set<Validation> getFailedValidations() {
        return this.failedValidations;
    }

    public String toString() {
        return Helper.toStringGenerator(this).field("status", (Object)this.status).field("genuineProbability", this.genuineProbability).field("box", this.box).field("failedValidations", this.failedValidations).generate();
    }
}

