/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.idliveface;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.idrnd.idliveface.CustomValidationParameters;
import net.idrnd.idliveface.Domain;
import net.idrnd.idliveface.FaceAnalyzer;
import net.idrnd.idliveface.FaceDetector;
import net.idrnd.idliveface.ImageDecoder;
import net.idrnd.idliveface.NativeObject;
import net.idrnd.idliveface.RuntimeConfiguration;
import net.idrnd.idliveface.Tolerance;
import net.idrnd.idliveface.Validation;

public class Blueprint
extends NativeObject {
    public Blueprint(String initDataPath) {
        super(Blueprint.init1(Objects.requireNonNull(initDataPath)));
    }

    public Blueprint(File initDataPath) {
        this(Objects.requireNonNull(initDataPath).toString());
    }

    public Blueprint(Path initDataPath) {
        this(Objects.requireNonNull(initDataPath).toString());
    }

    public Blueprint(String initDataPath, RuntimeConfiguration runtimeConfig) {
        super(Blueprint.init2(Objects.requireNonNull(initDataPath), Objects.requireNonNull(runtimeConfig)));
    }

    public Blueprint(File initDataPath, RuntimeConfiguration runtimeConfig) {
        this(Objects.requireNonNull(initDataPath).toString(), runtimeConfig);
    }

    public Blueprint(Path initDataPath, RuntimeConfiguration runtimeConfig) {
        this(Objects.requireNonNull(initDataPath).toString(), runtimeConfig);
    }

    private static native long init1(String var0);

    private static native long init2(String var0, RuntimeConfiguration var1);

    @Override
    protected native void release();

    public native List<String> getAvailablePipelines();

    public void setDomain(Domain domain) {
        this.setDomainInternal(Objects.requireNonNull(domain));
    }

    private native void setDomainInternal(Domain var1);

    public void setTolerance(Tolerance tolerance) {
        this.setToleranceInternal(Objects.requireNonNull(tolerance));
    }

    private native void setToleranceInternal(Tolerance var1);

    public native ImageDecoder createImageDecoder();

    public native FaceAnalyzer createFaceAnalyzer();

    public FaceAnalyzer createFaceAnalyzer(String pipeline) {
        return this.createFaceAnalyzerWithPipeline(Objects.requireNonNull(pipeline));
    }

    private native FaceAnalyzer createFaceAnalyzerWithPipeline(String var1);

    public native FaceDetector createFaceDetector();

    public void suppressValidation(Validation validation) {
        this.suppressValidationInternal(Objects.requireNonNull(validation), true);
    }

    public void suppressValidation(Validation validation, boolean suppress) {
        this.suppressValidationInternal(Objects.requireNonNull(validation), suppress);
    }

    private native void suppressValidationInternal(Validation var1, boolean var2);

    public void overrideValidationParameters(CustomValidationParameters customParameters) {
        Objects.requireNonNull(customParameters);
        this.overrideValidationParametersForDomainInternal(Domain.GENERAL, customParameters);
        this.overrideValidationParametersForDomainInternal(Domain.DESKTOP, customParameters);
    }

    public void overrideValidationParametersForDomain(Domain domain, CustomValidationParameters customParameters) {
        this.overrideValidationParametersForDomainInternal(Objects.requireNonNull(domain), Objects.requireNonNull(customParameters));
    }

    private native void overrideValidationParametersForDomainInternal(Domain var1, CustomValidationParameters var2);
}

