/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.facesdk.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.idrnd.facesdk.VersionInfo;

public class AssetsExtractor {
    public static final String DATA_SUBPATH = "data";
    private static final String LOG_TAG = "facesdk/AssetExtractor";
    private static final String PREF_ASSETS_VERSION = "assets-version";
    private final Context context;

    public AssetsExtractor(Context context) {
        this.context = context;
    }

    public File extractAssets(boolean force) {
        SharedPreferences prefs = this.context.getSharedPreferences("idliveface", 0);
        File filesDir = this.context.getFilesDir();
        String extractedVersion = prefs.getString(PREF_ASSETS_VERSION, null);
        String currentVersion = VersionInfo.getVersion();
        if (!force && currentVersion.equals(extractedVersion)) {
            Log.d((String)LOG_TAG, (String)"Assets are already extracted, skipping");
            return filesDir;
        }
        this.extractAssets("", filesDir);
        prefs.edit().putString(PREF_ASSETS_VERSION, currentVersion).apply();
        return filesDir;
    }

    public File extractAssets() {
        return this.extractAssets(false);
    }

    public void extractAssets(String assetSrc, File target) {
        AssetManager assetManager = this.context.getAssets();
        try {
            String[] assets = assetManager.list(assetSrc);
            if (assets.length == 0) {
                this.copyFile(assetSrc, target);
                return;
            }
            if (!target.exists()) {
                target.mkdir();
            }
            for (String asset : assets) {
                String nestedAsset = assetSrc.isEmpty() ? asset : assetSrc + "/" + asset;
                File nestedTarget = new File(target, asset);
                AssetsExtractor.cleanupNestedDir(nestedTarget);
                this.extractAssets(nestedAsset, nestedTarget);
            }
        }
        catch (IOException ex) {
            Log.e((String)LOG_TAG, (String)("Error extracting " + assetSrc + " to " + target), (Throwable)ex);
        }
    }

    private static void cleanupNestedDir(File target) {
        if (target.isDirectory()) {
            for (File child : target.listFiles()) {
                AssetsExtractor.cleanupNestedDir(child);
            }
        }
        target.delete();
    }

    private void copyFile(String assetName, File target) {
        boolean ok;
        File parentFolder;
        AssetManager assetManager = this.context.getAssets();
        if (target.exists()) {
            Log.v((String)LOG_TAG, (String)("Target file exists, overwriting: " + target));
        }
        if (!(parentFolder = target.getParentFile()).exists() && !(ok = parentFolder.mkdirs())) {
            Log.e((String)LOG_TAG, (String)("Exception creating parent dir for file " + target));
        }
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int read;
            in = assetManager.open(assetName);
            out = new FileOutputStream(target);
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Exception writing file " + assetName), (Throwable)e);
        }
    }
}

