/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.facesdk;

public class Meta {
    private Os os;
    private Manufacturer manufacturer;
    private Model model;
    private String osVersion;
    private Calibration calibration;

    public Meta() {
        this(Os.UNKNOWN, Manufacturer.UNKNOWN, Model.UNKNOWN, "", Calibration.REGULAR);
    }

    public Meta(Os os, Manufacturer manufacturer, Model model, String osVersion) {
        this(os, manufacturer, model, osVersion, Calibration.REGULAR);
    }

    public Meta(Os os, Manufacturer manufacturer, Model model, String osVersion, Calibration calibration) {
        this.os = os;
        this.manufacturer = manufacturer;
        this.model = model;
        this.osVersion = osVersion;
        this.calibration = calibration;
    }

    public Os getOs() {
        return this.os;
    }

    public void setOs(Os os) {
        this.os = os;
    }

    public Manufacturer getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(Manufacturer manufacturer) {
        this.manufacturer = manufacturer;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public Calibration getCalibration() {
        return this.calibration;
    }

    public void setCalibration(Calibration calibration) {
        this.calibration = calibration;
    }

    public int getOsOrdinal() {
        return this.os.ordinal();
    }

    public int getManufacturerOrdinal() {
        return this.manufacturer.ordinal();
    }

    public int getModelOrdinal() {
        return this.model.ordinal();
    }

    public int getCalibrationOrdinal() {
        return this.calibration.ordinal();
    }

    public String toString() {
        return "Meta{os=" + (Object)((Object)this.os) + ", manufacturer=" + (Object)((Object)this.manufacturer) + ", model=" + (Object)((Object)this.model) + ", osVersion='" + this.osVersion + '\'' + ", calibration=" + (Object)((Object)this.calibration) + '}';
    }

    public static enum Calibration {
        REGULAR(0),
        SOFT(1),
        HARDENED(2);

        private final int code;

        private Calibration(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Calibration fromCode(int code) {
            for (Calibration value : Calibration.values()) {
                if (value.code != code) continue;
                return value;
            }
            throw new RuntimeException("Invalid Calibration code: " + code);
        }
    }

    public static enum Model {
        UNKNOWN(0);

        private final int code;

        private Model(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Model fromCode(int code) {
            for (Model value : Model.values()) {
                if (value.code != code) continue;
                return value;
            }
            throw new RuntimeException("Invalid Model code: " + code);
        }
    }

    public static enum Manufacturer {
        UNKNOWN(0);

        private final int code;

        private Manufacturer(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Manufacturer fromCode(int code) {
            for (Manufacturer value : Manufacturer.values()) {
                if (value.code != code) continue;
                return value;
            }
            throw new RuntimeException("Invalid Manufacturer code: " + code);
        }
    }

    public static enum Os {
        ANDROID(0),
        IOS(1),
        DESKTOP(2),
        UNKNOWN(3);

        private final int code;

        private Os(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Os fromCode(int code) {
            for (Os value : Os.values()) {
                if (value.code != code) continue;
                return value;
            }
            throw new RuntimeException("Invalid Os code: " + code);
        }
    }
}

