/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.facesdk;

public class FaceException
extends RuntimeException {
    private final Status status;

    public FaceException(String raw) {
        super(raw.split(";", 2)[1]);
        int errorCodeIdx = Integer.parseInt(raw.split(";", 2)[0]);
        this.status = Status.values()[errorCodeIdx];
    }

    public FaceException(Status status, String message) {
        super(message);
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return "FaceException{status=" + (Object)((Object)this.status) + ", message=" + this.getMessage() + '}';
    }

    public static enum Status {
        FACE_TOO_CLOSE(0),
        FACE_CLOSE_TO_BORDER(1),
        FACE_CROPPED(2),
        FACE_NOT_FOUND(3),
        TOO_MANY_FACES(4),
        FACE_TOO_SMALL(5),
        FACE_ANGLE_TOO_LARGE(6),
        FAILED_TO_READ_IMAGE(7),
        FAILED_TO_WRITE_IMAGE(8),
        FAILED_TO_READ_MODEL(9),
        FAILED_TO_BUILD_INTERPRETER(10),
        FAILED_TO_INVOKE_INTERPRETER(11),
        FAILED_TO_ALLOCATE(12),
        INVALID_CONFIG(13),
        NO_SUCH_OBJECT_IN_BUILD(14),
        FAILED_TO_PREPROCESS_IMAGE_WHILE_PREDICT(15),
        FAILED_TO_PREPROCESS_IMAGE_WHILE_DETECT(16),
        FAILED_TO_PREDICT_LANDMARKS(17),
        INVALID_FUSE_MODE(18),
        NULLPTR(19),
        LICENSE_ERROR(20),
        INVALID_META(21),
        UNKNOWN(22),
        OK(23),
        FACE_IS_OCCLUDED(24),
        FAILED_TO_FETCH_COREML_DECRYPTION_KEY(25),
        EYES_CLOSED(26);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Status fromCode(int code) {
            for (Status value : Status.values()) {
                if (value.code != code) continue;
                return value;
            }
            throw new RuntimeException("Invalid Status code: " + code);
        }
    }
}

