/*
 * Decompiled with CFR 0.152.
 */
package net.idrnd.facesdk;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ColorEncoding {
    RGB888(0L),
    BGR888(1L);

    private static final Map<Long, ColorEncoding> COLOR_ENCODING_VALUE_TO_COLOR_ENCODING;
    private final long value;

    private ColorEncoding(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public static ColorEncoding parse(long value) {
        return COLOR_ENCODING_VALUE_TO_COLOR_ENCODING.get(value);
    }

    static {
        COLOR_ENCODING_VALUE_TO_COLOR_ENCODING = Stream.of(ColorEncoding.values()).collect(Collectors.toMap(ColorEncoding::getValue, Function.identity()));
    }
}

