//
//  ViewController.m
//  FaceThermal
//
//  Copyright (c) 2020 Luxand, Inc. All rights reserved.
//

#import "ViewController.h"
#include "LuxandFaceSDK.h"

@interface ViewController ()

@end

@implementation ViewController

//for Xcode 4.2 support (not needed in Xcode 4.4+)
@synthesize label=_label;
@synthesize imageview=_imageview;


- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewDidUnload {
    [self setLabel:nil];
    [self setImageview:nil];
    [super viewDidUnload];
}

- (IBAction)loadButton:(id)sender {
    imagepicker = [[UIImagePickerController alloc] init];
    imagepicker.delegate = self;
    imagepicker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    
    if( UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad){
        popOverController = [[UIPopoverController alloc] initWithContentViewController:imagepicker];
        [popOverController presentPopoverFromRect:CGRectMake(0, 0, imagepicker.view.frame.size.width, imagepicker.view.frame.size.height) inView:self.view permittedArrowDirections:NO animated:NO];        
    } else {
        [self.view addSubview:imagepicker.view];
    }
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info {

    // Picked image
    UIImage * img = [info objectForKey:UIImagePickerControllerOriginalImage];
    
    // Load image to FaceSDK
    NSData * jpegbuf = UIImageJPEGRepresentation(img, 0.9f);
    unsigned int len = jpegbuf.length;
    unsigned char * ptr = (unsigned char *)jpegbuf.bytes;
    NSLog(@"image buffer len %d, ptr %p\n", len, ptr);
    HImage fsdk_img;
    int res = FSDK_LoadImageFromJpegBuffer(&fsdk_img, ptr, len);
    if (res != FSDKE_OK) {
        NSString * str = [[NSString alloc] initWithFormat: @"error loading image to FaceSDK: %d\n", res];
        self.label.text = str;
        NSLog(@"error loading image to FaceSDK: %d\n", res);
        return;
    }
    
    // Detect face
    int faceCount = 0;
    TFacePosition faces[256];
    FSDK_DetectMultipleFaces(fsdk_img, &faceCount, faces, 256*sizeof(TFacePosition));
    
    // Unload image from FaceSDK
    FSDK_FreeImage(fsdk_img);
    
    // Draw faces
    for (int i=0; i<faceCount; ++i) {
        UIGraphicsBeginImageContext(img.size);
        [img drawAtPoint:CGPointZero];
        CGContextRef ctx = UIGraphicsGetCurrentContext();
        CGContextSetLineWidth(ctx, 2.0f);
        [[UIColor blueColor] setStroke];
        TFacePosition facepos = faces[i];
        CGRect facerect = CGRectMake(facepos.xc - facepos.w/2.0f, facepos.yc - facepos.w/2.0f, facepos.w, facepos.w);
        CGContextStrokeRect(ctx, facerect);
        img = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
    }
    
    // Show image
    self.imageview.contentMode = UIViewContentModeScaleAspectFit;
    self.imageview.image = img;
    self.imageview.hidden = NO;
    
    // Remove image picker
    if( UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad){
        [popOverController dismissPopoverAnimated:NO];
        popOverController = NULL;
    } else {
        [imagepicker.view removeFromSuperview];
    }
    imagepicker = NULL;
}

- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {
    if( UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad){
        [popOverController dismissPopoverAnimated:NO];
        popOverController = NULL;
    } else {
        [imagepicker.view removeFromSuperview];
    }
    imagepicker = NULL;
}


@end
