﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using Luxand;

namespace FaceThermal
{
    public partial class MainForm : Form
    {
        // WinAPI procedure to release HBITMAP handles returned by FSDKCam.GrabFrame
        [DllImport("gdi32.dll")]
        static extern bool DeleteObject(IntPtr hObject);

        public MainForm()
        {
            InitializeComponent();
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            if (FSDK.FSDKE_OK != FSDK.ActivateLibrary("INSERT THE LICENSE KEY HERE"))
            {
                MessageBox.Show("Please insert the license key in the FSDK.ActivateLibrary() function.", "Error activating FaceSDK", MessageBoxButtons.OK, MessageBoxIcon.Error);
                Application.Exit();
            }

            FSDK.InitializeLibrary();
            FSDK.SetFaceDetectionParameters(true, true, 256);
            int res = 0;
            FSDK.SetParameters("FaceDetectionModel=thermal.bin;TrimOutOfScreenFaces=false;TrimFacesWithUncertainFacialFeatures=false", out res);
            if (res != 0) {
                MessageBox.Show("Error loading face detection model", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                Application.Exit(); 
            }
        }

        private void btnOpenPhoto_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    Luxand.CImage image = new Luxand.CImage(openFileDialog1.FileName);

                    // resize image to fit the window width
                    double ratio = System.Math.Min((pictureBox1.Width + 0.4) / image.Width,
                        (pictureBox1.Height + 0.4) / image.Height);
                    image = image.Resize(ratio);
                    
                    Image frameImage = image.ToCLRImage();
                    Graphics gr = Graphics.FromImage(frameImage);

                    FSDK.TFacePosition[] facePositions = image.DetectMultipleFaces();
                    if (facePositions.Length <= 0)
                        MessageBox.Show("No faces detected", "Face Detection");
                    else
                    {
                        foreach (FSDK.TFacePosition facePosition in facePositions)
                        {
                            int left = facePosition.xc - (int)(facePosition.w * 0.6f);
                            int top = facePosition.yc - (int)(facePosition.w * 0.5f);
                            gr.DrawRectangle(Pens.LightGreen, left, top, (int)(facePosition.w * 1.2), (int)(facePosition.w * 1.2));
                        }
                        
                        gr.Flush();
                    }

                    // display image
                    pictureBox1.Image = frameImage;
                    pictureBox1.Refresh();
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, "Exception");
                }
            }
        }
    }
}
