package com.luxand.passiveliveness;

import Luxand.FSDK;

public class Face {
    
    public class Frame {
        
        public final int x, y, width, height;
        
        public Frame(final int x, final int y, final int width, final int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
        
    }
    
    private long id;
    private FSDK.TFacePosition.ByReference facePosition = new FSDK.TFacePosition.ByReference();
    private float[] similarity = new float[1];
    
    public FSDK.TFacePosition getFacePosition() {
        return facePosition;
    }
    
    public FSDK.TFacePosition.ByReference getFacePositionReference() {
        return facePosition;
    }
    
    public float[] getSimilarityReference() {
        return similarity;
    }
    
    public float getSimilarity() {
        return similarity[0];
    }
    
    public void setSimilarity(float value) {
        similarity[0] = value;
    }
    
    public long getID() {
        return id;
    }
    
    public void setID(long id) {
        this.id = id;
    }
    
    public Frame getFrame() {
        final int w = facePosition.w;
        final int h = (int)(w * 1.2);
        final int x = facePosition.xc - w / 2;
        final int y = facePosition.yc - h / 2;
        
        return new Frame(x, y, w, h);
    }
    
}
