/*
 * Decompiled with CFR 0.152.
 */
package Luxand;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FSDK {
    public static final int FSDKE_OK = 0;
    public static final int FSDKE_FAILED = -1;
    public static final int FSDKE_NOT_ACTIVATED = -2;
    public static final int FSDKE_OUT_OF_MEMORY = -3;
    public static final int FSDKE_INVALID_ARGUMENT = -4;
    public static final int FSDKE_IO_ERROR = -5;
    public static final int FSDKE_IMAGE_TOO_SMALL = -6;
    public static final int FSDKE_FACE_NOT_FOUND = -7;
    public static final int FSDKE_INSUFFICIENT_BUFFER_SIZE = -8;
    public static final int FSDKE_UNSUPPORTED_IMAGE_EXTENSION = -9;
    public static final int FSDKE_CANNOT_OPEN_FILE = -10;
    public static final int FSDKE_CANNOT_CREATE_FILE = -11;
    public static final int FSDKE_BAD_FILE_FORMAT = -12;
    public static final int FSDKE_FILE_NOT_FOUND = -13;
    public static final int FSDKE_CONNECTION_CLOSED = -14;
    public static final int FSDKE_CONNECTION_FAILED = -15;
    public static final int FSDKE_IP_INIT_FAILED = -16;
    public static final int FSDKE_NEED_SERVER_ACTIVATION = -17;
    public static final int FSDKE_ID_NOT_FOUND = -18;
    public static final int FSDKE_ATTRIBUTE_NOT_DETECTED = -19;
    public static final int FSDKE_INSUFFICIENT_TRACKER_MEMORY_LIMIT = -20;
    public static final int FSDKE_UNKNOWN_ATTRIBUTE = -21;
    public static final int FSDKE_UNSUPPORTED_FILE_VERSION = -22;
    public static final int FSDKE_SYNTAX_ERROR = -23;
    public static final int FSDKE_PARAMETER_NOT_FOUND = -24;
    public static final int FSDKE_INVALID_TEMPLATE = -25;
    public static final int FSDKE_UNSUPPORTED_TEMPLATE_VERSION = -26;
    public static final int FSDKE_CAMERA_INDEX_DOES_NOT_EXIST = -27;
    public static final int FSDKE_PLATFORM_NOT_LICENSED = -28;
    public static final int FSDKE_TENSORFLOW_NOT_INITIALIZED = -29;
    public static final int FSDKE_PLUGIN_NOT_LOADED = -30;
    public static final int FSDKE_PLUGIN_NO_PERMISSION = -31;
    public static final int FSDKE_FACEID_NOT_FOUND = -32;
    public static final int FSDKE_FACEIMAGE_NOT_FOUND = -33;
    public static final int FSDKE_IBETA_INITIALIZATION_ERROR = -200;
    public static final int FSDK_FACIAL_FEATURE_COUNT = 70;
    private static final int sizeofTFacePosition = 24;
    private static final int sizeofIDSimilarity = 16;
    public static final int FSDKP_LEFT_EYE = 0;
    public static final int FSDKP_RIGHT_EYE = 1;
    public static final int FSDKP_LEFT_EYE_INNER_CORNER = 24;
    public static final int FSDKP_LEFT_EYE_OUTER_CORNER = 23;
    public static final int FSDKP_LEFT_EYE_LOWER_LINE1 = 38;
    public static final int FSDKP_LEFT_EYE_LOWER_LINE2 = 27;
    public static final int FSDKP_LEFT_EYE_LOWER_LINE3 = 37;
    public static final int FSDKP_LEFT_EYE_UPPER_LINE1 = 35;
    public static final int FSDKP_LEFT_EYE_UPPER_LINE2 = 28;
    public static final int FSDKP_LEFT_EYE_UPPER_LINE3 = 36;
    public static final int FSDKP_LEFT_EYE_LEFT_IRIS_CORNER = 29;
    public static final int FSDKP_LEFT_EYE_RIGHT_IRIS_CORNER = 30;
    public static final int FSDKP_RIGHT_EYE_INNER_CORNER = 25;
    public static final int FSDKP_RIGHT_EYE_OUTER_CORNER = 26;
    public static final int FSDKP_RIGHT_EYE_LOWER_LINE1 = 41;
    public static final int FSDKP_RIGHT_EYE_LOWER_LINE2 = 31;
    public static final int FSDKP_RIGHT_EYE_LOWER_LINE3 = 42;
    public static final int FSDKP_RIGHT_EYE_UPPER_LINE1 = 40;
    public static final int FSDKP_RIGHT_EYE_UPPER_LINE2 = 32;
    public static final int FSDKP_RIGHT_EYE_UPPER_LINE3 = 39;
    public static final int FSDKP_RIGHT_EYE_LEFT_IRIS_CORNER = 33;
    public static final int FSDKP_RIGHT_EYE_RIGHT_IRIS_CORNER = 34;
    public static final int FSDKP_LEFT_EYEBROW_INNER_CORNER = 13;
    public static final int FSDKP_LEFT_EYEBROW_MIDDLE = 16;
    public static final int FSDKP_LEFT_EYEBROW_MIDDLE_LEFT = 18;
    public static final int FSDKP_LEFT_EYEBROW_MIDDLE_RIGHT = 19;
    public static final int FSDKP_LEFT_EYEBROW_OUTER_CORNER = 12;
    public static final int FSDKP_RIGHT_EYEBROW_INNER_CORNER = 14;
    public static final int FSDKP_RIGHT_EYEBROW_MIDDLE = 17;
    public static final int FSDKP_RIGHT_EYEBROW_MIDDLE_LEFT = 20;
    public static final int FSDKP_RIGHT_EYEBROW_MIDDLE_RIGHT = 21;
    public static final int FSDKP_RIGHT_EYEBROW_OUTER_CORNER = 15;
    public static final int FSDKP_NOSE_TIP = 2;
    public static final int FSDKP_NOSE_BOTTOM = 49;
    public static final int FSDKP_NOSE_BRIDGE = 22;
    public static final int FSDKP_NOSE_LEFT_WING = 43;
    public static final int FSDKP_NOSE_LEFT_WING_OUTER = 45;
    public static final int FSDKP_NOSE_LEFT_WING_LOWER = 47;
    public static final int FSDKP_NOSE_RIGHT_WING = 44;
    public static final int FSDKP_NOSE_RIGHT_WING_OUTER = 46;
    public static final int FSDKP_NOSE_RIGHT_WING_LOWER = 48;
    public static final int FSDKP_MOUTH_RIGHT_CORNER = 3;
    public static final int FSDKP_MOUTH_LEFT_CORNER = 4;
    public static final int FSDKP_MOUTH_TOP = 54;
    public static final int FSDKP_MOUTH_TOP_INNER = 61;
    public static final int FSDKP_MOUTH_BOTTOM = 55;
    public static final int FSDKP_MOUTH_BOTTOM_INNER = 64;
    public static final int FSDKP_MOUTH_LEFT_TOP = 56;
    public static final int FSDKP_MOUTH_LEFT_TOP_INNER = 60;
    public static final int FSDKP_MOUTH_RIGHT_TOP = 57;
    public static final int FSDKP_MOUTH_RIGHT_TOP_INNER = 62;
    public static final int FSDKP_MOUTH_LEFT_BOTTOM = 58;
    public static final int FSDKP_MOUTH_LEFT_BOTTOM_INNER = 63;
    public static final int FSDKP_MOUTH_RIGHT_BOTTOM = 59;
    public static final int FSDKP_MOUTH_RIGHT_BOTTOM_INNER = 65;
    public static final int FSDKP_NASOLABIAL_FOLD_LEFT_UPPER = 50;
    public static final int FSDKP_NASOLABIAL_FOLD_LEFT_LOWER = 52;
    public static final int FSDKP_NASOLABIAL_FOLD_RIGHT_UPPER = 51;
    public static final int FSDKP_NASOLABIAL_FOLD_RIGHT_LOWER = 53;
    public static final int FSDKP_CHIN_BOTTOM = 11;
    public static final int FSDKP_CHIN_LEFT = 9;
    public static final int FSDKP_CHIN_RIGHT = 10;
    public static final int FSDKP_FACE_CONTOUR1 = 7;
    public static final int FSDKP_FACE_CONTOUR2 = 5;
    public static final int FSDKP_FACE_CONTOUR12 = 6;
    public static final int FSDKP_FACE_CONTOUR13 = 8;
    public static final int FSDKP_FACE_CONTOUR14 = 66;
    public static final int FSDKP_FACE_CONTOUR15 = 67;
    public static final int FSDKP_FACE_CONTOUR16 = 68;
    public static final int FSDKP_FACE_CONTOUR17 = 69;
    private static final NativeLibrary library = NativeLibrary.getInstance((String)(Platform.isWindows() || Platform.isWindowsCE() ? "facesdk" : "fsdk"));
    private static final Function _FSDK_SaveImageToFileW;
    private static final Function _FSDK_LoadImageFromFileW;
    private static final Function _FSDK_LoadImageFromFileWithAlphaW;

    private static native int FSDK_ActivateLibrary(String var0);

    private static native int FSDK_SetNumThreads(int var0);

    private static native int FSDK_GetNumThreads(IntByReference var0);

    private static native int FSDK_Initialize(String var0);

    private static native int FSDK_GetHardware_ID(Pointer var0);

    private static native int FSDK_GetLicenseInfo(Pointer var0);

    private static native int FSDK_GetVersionInfo(Pointer var0);

    private static native int FSDK_Finalize();

    private static native int FSDK_DetectFace(int var0, TFacePosition.ByReference var1);

    private static native int FSDK_DetectMultipleFaces(int var0, IntByReference var1, Pointer var2, int var3);

    private static native int FSDK_DetectEyes(int var0, FSDK_Features.ByReference var1);

    private static native int FSDK_DetectEyesInRegion(int var0, TFacePosition var1, FSDK_Features.ByReference var2);

    private static native int FSDK_DetectFacialFeatures(int var0, FSDK_Features.ByReference var1);

    private static native int FSDK_DetectFacialFeaturesInRegion(int var0, TFacePosition var1, FSDK_Features.ByReference var2);

    private static native int FSDK_SetFaceDetectionParameters(byte var0, byte var1, int var2);

    private static native int FSDK_SetFaceDetectionThreshold(int var0);

    private static native int FSDK_CreateEmptyImage(IntByReference var0);

    private static native int FSDK_LoadImageFromFile(IntByReference var0, String var1);

    private static native int FSDK_LoadImageFromFileWithAlpha(IntByReference var0, String var1);

    private static native int FSDK_LoadImageFromBuffer(IntByReference var0, byte[] var1, int var2, int var3, int var4, int var5);

    private static native int FSDK_LoadImageFromJpegBuffer(IntByReference var0, byte[] var1, int var2);

    private static native int FSDK_LoadImageFromPngBuffer(IntByReference var0, byte[] var1, int var2);

    private static native int FSDK_FreeImage(int var0);

    private static native int FSDK_SaveImageToFile(int var0, String var1);

    private static native int FSDK_GetImageBufferSize(int var0, IntByReference var1, int var2);

    private static native int FSDK_SaveImageToBuffer(int var0, byte[] var1, int var2);

    private static native int FSDK_SetJpegCompressionQuality(int var0);

    private static native int FSDK_CopyImage(int var0, int var1);

    private static native int FSDK_ResizeImage(int var0, double var1, int var3);

    private static native int FSDK_RotateImage90(int var0, int var1, int var2);

    private static native int FSDK_RotateImage(int var0, double var1, int var3);

    private static native int FSDK_RotateImageCenter(int var0, double var1, double var3, double var5, int var7);

    private static native int FSDK_CopyRect(int var0, int var1, int var2, int var3, int var4, int var5);

    private static native int FSDK_CopyRectReplicateBorder(int var0, int var1, int var2, int var3, int var4, int var5);

    private static native int FSDK_MirrorImage(int var0, byte var1);

    private static native int FSDK_GetImageWidth(int var0, IntByReference var1);

    private static native int FSDK_GetImageHeight(int var0, IntByReference var1);

    private static native int FSDK_ExtractFaceImage(int var0, FSDK_Features.ByReference var1, int var2, int var3, IntByReference var4, FSDK_Features.ByReference var5);

    private static native int FSDK_GetFaceTemplate(int var0, FSDK_FaceTemplate.ByReference var1);

    private static native int FSDK_MatchFaces(FSDK_FaceTemplate.ByReference var0, FSDK_FaceTemplate.ByReference var1, FloatByReference var2);

    private static native int FSDK_GetFaceTemplateInRegion(int var0, TFacePosition var1, FSDK_FaceTemplate.ByReference var2);

    private static native int FSDK_GetFaceTemplateUsingFeatures(int var0, FSDK_Features var1, FSDK_FaceTemplate.ByReference var2);

    private static native int FSDK_GetFaceTemplateUsingEyes(int var0, FSDK_Features var1, FSDK_FaceTemplate.ByReference var2);

    private static native int FSDK_GetMatchingThresholdAtFAR(float var0, FloatByReference var1);

    private static native int FSDK_GetMatchingThresholdAtFRR(float var0, FloatByReference var1);

    private static native int FSDK_GetDetectedFaceConfidence(IntByReference var0);

    private static native int FSDK_CreateTracker(IntByReference var0);

    private static native int FSDK_FreeTracker(int var0);

    private static native int FSDK_ClearTracker(int var0);

    private static native int FSDK_SetTrackerParameter(int var0, String var1, String var2);

    private static native int FSDK_SetTrackerMultipleParameters(int var0, String var1, IntByReference var2);

    private static native int FSDK_GetTrackerParameter(int var0, String var1, Pointer var2, long var3);

    private static native int FSDK_FeedFrame(int var0, long var1, int var3, LongByReference var4, Pointer var5, long var6);

    private static native int FSDK_GetTrackerEyes(int var0, long var1, long var3, FSDK_Features.ByReference var5);

    private static native int FSDK_GetTrackerFacialFeatures(int var0, long var1, long var3, FSDK_Features.ByReference var5);

    private static native int FSDK_GetTrackerFacePosition(int var0, long var1, long var3, TFacePosition.ByReference var5);

    private static native int FSDK_LockID(int var0, long var1);

    private static native int FSDK_UnlockID(int var0, long var1);

    private static native int FSDK_PurgeID(int var0, long var1);

    private static native int FSDK_GetName(int var0, long var1, Pointer var3, long var4);

    private static native int FSDK_SetName(int var0, long var1, String var3);

    private static native int FSDK_GetIDReassignment(int var0, long var1, LongByReference var3);

    private static native int FSDK_GetSimilarIDCount(int var0, long var1, LongByReference var3);

    private static native int FSDK_GetSimilarIDList(int var0, long var1, Pointer var3, long var4);

    private static native int FSDK_GetTrackerIDsCount(int var0, LongByReference var1);

    private static native int FSDK_GetTrackerAllIDs(int var0, Pointer var1, long var2);

    private static native int FSDK_GetTrackerFaceIDsCountForID(int var0, long var1, LongByReference var3);

    private static native int FSDK_GetTrackerFaceIDsForID(int var0, long var1, Pointer var3, long var4);

    private static native int FSDK_GetTrackerIDByFaceID(int var0, long var1, LongByReference var3);

    private static native int FSDK_GetTrackerFaceTemplate(int var0, long var1, FSDK_FaceTemplate.ByReference var3);

    private static native int FSDK_TrackerCreateID(int var0, FSDK_FaceTemplate.ByReference var1, LongByReference var2, LongByReference var3);

    private static native int FSDK_AddTrackerFaceTemplate(int var0, long var1, FSDK_FaceTemplate.ByReference var3, LongByReference var4);

    private static native int FSDK_DeleteTrackerFace(int var0, long var1);

    private static native int FSDK_GetTrackerFaceImage(int var0, long var1, IntByReference var3);

    private static native int FSDK_SetTrackerFaceImage(int var0, long var1, int var3);

    private static native int FSDK_DeleteTrackerFaceImage(int var0, long var1);

    private static native int FSDK_TrackerMatchFaces(int var0, FSDK_FaceTemplate.ByReference var1, float var2, Pointer var3, LongByReference var4, long var5);

    private static native int FSDK_GetAllNames(int var0, long var1, Pointer var3, long var4);

    private static native int FSDK_LoadTrackerMemoryFromFile(IntByReference var0, String var1);

    private static native int FSDK_SaveTrackerMemoryToFile(int var0, String var1);

    private static native int FSDK_LoadTrackerMemoryFromBuffer(IntByReference var0, byte[] var1);

    private static native int FSDK_GetTrackerMemoryBufferSize(int var0, LongByReference var1);

    private static native int FSDK_SaveTrackerMemoryToBuffer(int var0, byte[] var1, long var2);

    private static native int FSDK_GetTrackerFacialAttribute(int var0, long var1, long var3, String var5, Pointer var6, long var7);

    private static native int FSDK_DetectFacialAttributeUsingFeatures(int var0, FSDK_Features var1, String var2, Pointer var3, long var4);

    private static native int FSDK_GetValueConfidence(String var0, String var1, FloatByReference var2);

    private static native int FSDK_SetParameter(String var0, String var1);

    private static native int FSDK_SetParameters(String var0, IntByReference var1);

    private static int FSDK_SaveImageToFileW(int Image2, WString FileName) {
        return _FSDK_SaveImageToFileW.invokeInt(new Object[]{Image2, FileName});
    }

    private static int FSDK_LoadImageFromFileW(IntByReference Image2, WString FileName) {
        return _FSDK_LoadImageFromFileW.invokeInt(new Object[]{Image2, FileName});
    }

    private static int FSDK_LoadImageFromFileWithAlphaW(IntByReference Image2, WString FileName) {
        return _FSDK_LoadImageFromFileW.invokeInt(new Object[]{Image2, FileName});
    }

    public static int GetHardware_ID(String[] HardwareID) {
        if (HardwareID.length < 1) {
            return -4;
        }
        Memory buf = new Memory(1024L);
        int res = FSDK.FSDK_GetHardware_ID((Pointer)buf);
        if (res == 0) {
            HardwareID[0] = buf.getString(0L);
        }
        return res;
    }

    public static int GetLicenseInfo(String[] LicenseInfo) {
        if (LicenseInfo.length < 1) {
            return -4;
        }
        Memory buf = new Memory(1024L);
        int res = FSDK.FSDK_GetLicenseInfo((Pointer)buf);
        if (res == 0) {
            LicenseInfo[0] = buf.getString(0L);
        }
        return res;
    }

    public static int GetVersionInfo(String[] VersionInfo) {
        if (VersionInfo.length < 1) {
            return -4;
        }
        Memory buf = new Memory((long)Native.POINTER_SIZE);
        int res = FSDK.FSDK_GetVersionInfo((Pointer)buf);
        if (res == 0) {
            VersionInfo[0] = buf.getPointer(0L).getString(0L);
        }
        return res;
    }

    public static int ActivateLibrary(String LicenseKey) {
        FSDK.FSDK_SetParameter("environment", "java");
        return FSDK.FSDK_ActivateLibrary(LicenseKey);
    }

    public static int SetNumThreads(int Num) {
        return FSDK.FSDK_SetNumThreads(Num);
    }

    public static int GetNumThreads(int[] Num) {
        if (Num.length < 1) {
            return -4;
        }
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_GetNumThreads(tmp);
        Num[0] = tmp.getValue();
        return res;
    }

    public static int Initialize() {
        return FSDK.FSDK_Initialize("");
    }

    public static int Finalize() {
        return FSDK.FSDK_Finalize();
    }

    public static int CreateEmptyImage(HImage Image2) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_CreateEmptyImage(tmp);
        Image2.himage = tmp.getValue();
        return res;
    }

    public static int FreeImage(HImage Image2) {
        return FSDK.FSDK_FreeImage(Image2.himage);
    }

    public static int LoadImageFromFile(HImage Image2, String FileName) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_LoadImageFromFile(tmp, FileName);
        Image2.himage = tmp.getValue();
        return res;
    }

    public static int LoadImageFromFileW(HImage Image2, String FileName) {
        IntByReference tmp = new IntByReference();
        int res = 0;
        res = Platform.isWindows() || Platform.isWindowsCE() ? FSDK.FSDK_LoadImageFromFileW(tmp, new WString(FileName)) : FSDK.FSDK_LoadImageFromFile(tmp, FileName);
        Image2.himage = tmp.getValue();
        return res;
    }

    public static int LoadImageFromFileWithAlpha(HImage Image2, String FileName) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_LoadImageFromFileWithAlpha(tmp, FileName);
        Image2.himage = tmp.getValue();
        return res;
    }

    public static int LoadImageFromFileWithAlphaW(HImage Image2, String FileName) {
        IntByReference tmp = new IntByReference();
        int res = 0;
        res = Platform.isWindows() || Platform.isWindowsCE() ? FSDK.FSDK_LoadImageFromFileWithAlphaW(tmp, new WString(FileName)) : FSDK.FSDK_LoadImageFromFileWithAlpha(tmp, FileName);
        Image2.himage = tmp.getValue();
        return res;
    }

    public static int SaveImageToFile(HImage Image2, String FileName) {
        return FSDK.FSDK_SaveImageToFile(Image2.himage, FileName);
    }

    public static int SaveImageToFileW(HImage Image2, String FileName) {
        if (Platform.isWindows() || Platform.isWindowsCE()) {
            return FSDK.FSDK_SaveImageToFileW(Image2.himage, new WString(FileName));
        }
        return FSDK.FSDK_SaveImageToFile(Image2.himage, FileName);
    }

    public static int GetImageWidth(HImage Image2, int[] Width) {
        if (Width.length < 1) {
            return -4;
        }
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_GetImageWidth(Image2.himage, tmp);
        if (res == 0) {
            Width[0] = tmp.getValue();
        }
        return res;
    }

    public static int GetImageHeight(HImage Image2, int[] Height) {
        if (Height.length < 1) {
            return -4;
        }
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_GetImageHeight(Image2.himage, tmp);
        if (res == 0) {
            Height[0] = tmp.getValue();
        }
        return res;
    }

    public static int SaveImageToAWTImage(HImage Image2, Image[] DestImage, int ImageMode) {
        if (DestImage.length < 1) {
            return -4;
        }
        IntByReference bufSize = new IntByReference();
        int res = FSDK.FSDK_GetImageBufferSize(Image2.himage, bufSize, ImageMode);
        if (res != 0) {
            return res;
        }
        int[] w = new int[1];
        res = FSDK.GetImageWidth(Image2, w);
        if (res != 0) {
            return res;
        }
        int[] h = new int[1];
        res = FSDK.GetImageHeight(Image2, h);
        if (res != 0) {
            return res;
        }
        byte[] Buffer = new byte[bufSize.getValue()];
        if (w[0] == 0 || h[0] == 0) {
            return -1;
        }
        res = FSDK.FSDK_SaveImageToBuffer(Image2.himage, Buffer, ImageMode);
        if (res != 0) {
            return res;
        }
        if (ImageMode == 1) {
            int[] pix = new int[w[0] * h[0]];
            for (int i = 0; i < bufSize.getValue() / 3; ++i) {
                byte r = Buffer[i * 3 + 0];
                byte g = Buffer[i * 3 + 1];
                byte b = Buffer[i * 3 + 2];
                pix[i] = -16777216 + (r << 16) + (g << 8) + b;
            }
            DestImage[0] = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w[0], h[0], pix, 0, w[0]));
        } else if (ImageMode == 2) {
            int[] pix = new int[w[0] * h[0]];
            for (int i = 0; i < bufSize.getValue() / 4; ++i) {
                byte a = Buffer[i * 4 + 3];
                if (a == 0) {
                    pix[i] = 0;
                    continue;
                }
                byte r = Buffer[i * 4 + 0];
                byte g = Buffer[i * 4 + 1];
                byte b = Buffer[i * 4 + 2];
                pix[i] = (a << 24) + (r << 16) + (g << 8) + b;
            }
            DirectColorModel cm = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
            DestImage[0] = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w[0], h[0], (ColorModel)cm, pix, 0, w[0]));
        } else if (ImageMode == 0) {
            int[] pix = new int[w[0] * h[0]];
            for (int i = 0; i < bufSize.getValue(); ++i) {
                byte p = Buffer[i];
                pix[i] = -16777216 + (p << 16) + (p << 8) + p;
            }
            ColorModel cm = ColorModel.getRGBdefault();
            DestImage[0] = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w[0], h[0], cm, pix, 0, w[0]));
        } else {
            return -4;
        }
        return 0;
    }

    public static int LoadImageFromAWTImage(HImage Image2, Image SourceImage, int ImageMode) {
        PixelGrabber pg = new PixelGrabber(SourceImage, 0, 0, SourceImage.getWidth(null), SourceImage.getHeight(null), false);
        try {
            if (pg.grabPixels()) {
                int w = pg.getWidth();
                int h = pg.getHeight();
                Object grabbed = pg.getPixels();
                if (ImageMode == 0 && grabbed instanceof byte[]) {
                    byte[] Buffer = (byte[])grabbed;
                    IntByReference tmp = new IntByReference();
                    int res = FSDK.FSDK_LoadImageFromBuffer(tmp, Buffer, w, h, w, ImageMode);
                    Image2.himage = tmp.getValue();
                    return res;
                }
                if (ImageMode == 2 && grabbed instanceof int[]) {
                    int[] intBuffer = (int[])grabbed;
                    byte[] Buffer = new byte[w * h * 4];
                    for (int i = 0; i < w * h; ++i) {
                        int pixel = intBuffer[i];
                        Buffer[i * 4 + 0] = (byte)(pixel >> 16 & 0xFF);
                        Buffer[i * 4 + 1] = (byte)(pixel >> 8 & 0xFF);
                        Buffer[i * 4 + 2] = (byte)(pixel & 0xFF);
                        Buffer[i * 4 + 3] = (byte)(pixel >> 24 & 0xFF);
                    }
                    IntByReference tmp = new IntByReference();
                    int res = FSDK.FSDK_LoadImageFromBuffer(tmp, Buffer, w, h, 4 * w, ImageMode);
                    Image2.himage = tmp.getValue();
                    return res;
                }
                if (ImageMode == 1 && grabbed instanceof int[]) {
                    int[] intBuffer = (int[])grabbed;
                    byte[] Buffer = new byte[w * h * 3];
                    for (int i = 0; i < w * h; ++i) {
                        int pixel = intBuffer[i];
                        Buffer[i * 3 + 0] = (byte)(pixel >> 16 & 0xFF);
                        Buffer[i * 3 + 1] = (byte)(pixel >> 8 & 0xFF);
                        Buffer[i * 3 + 2] = (byte)(pixel & 0xFF);
                    }
                    IntByReference tmp = new IntByReference();
                    int res = FSDK.FSDK_LoadImageFromBuffer(tmp, Buffer, w, h, 3 * w, ImageMode);
                    Image2.himage = tmp.getValue();
                    return res;
                }
                return -4;
            }
            return -5;
        }
        catch (InterruptedException e1) {
            return -1;
        }
    }

    public static int LoadImageFromPngBuffer(HImage Image2, byte[] Buffer, int BufferLength) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_LoadImageFromPngBuffer(tmp, Buffer, BufferLength);
        Image2.himage = tmp.getValue();
        return res;
    }

    public static int LoadImageFromJpegBuffer(HImage Image2, byte[] Buffer, int BufferLength) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_LoadImageFromJpegBuffer(tmp, Buffer, BufferLength);
        Image2.himage = tmp.getValue();
        return res;
    }

    public static int LoadImageFromBuffer(HImage Image2, byte[] Buffer, int Width, int Height, int ScanLine, int ImageMode) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_LoadImageFromBuffer(tmp, Buffer, Width, Height, ScanLine, ImageMode);
        Image2.himage = tmp.getValue();
        return res;
    }

    public static int GetImageBufferSize(HImage Image2, int[] BufSize, int ImageMode) {
        if (BufSize.length < 1) {
            return -4;
        }
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_GetImageBufferSize(Image2.himage, tmp, ImageMode);
        if (res == 0) {
            BufSize[0] = tmp.getValue();
        }
        return res;
    }

    public static int SaveImageToBuffer(HImage Image2, byte[] Buffer, int ImageMode) {
        return FSDK.FSDK_SaveImageToBuffer(Image2.himage, Buffer, ImageMode);
    }

    public static int DetectFace(HImage Image2, TFacePosition.ByReference FacePosition) {
        return FSDK.FSDK_DetectFace(Image2.himage, FacePosition);
    }

    public static int DetectFacialFeatures(HImage Image2, FSDK_Features.ByReference FacialFeatures) {
        return FSDK.FSDK_DetectFacialFeatures(Image2.himage, FacialFeatures);
    }

    public static int DetectFacialFeaturesInRegion(HImage Image2, TFacePosition FacePosition, FSDK_Features.ByReference FacialFeatures) {
        return FSDK.FSDK_DetectFacialFeaturesInRegion(Image2.himage, FacePosition, FacialFeatures);
    }

    public static int DetectEyes(HImage Image2, FSDK_Features.ByReference Eyes) {
        return FSDK.FSDK_DetectEyes(Image2.himage, Eyes);
    }

    public static int DetectEyesInRegion(HImage Image2, TFacePosition FacePosition, FSDK_Features.ByReference Eyes) {
        return FSDK.FSDK_DetectEyesInRegion(Image2.himage, FacePosition, Eyes);
    }

    public static int DetectMultipleFaces(HImage Image2, TFaces FacePositions) {
        int bs = 24 * FacePositions.maxFaces;
        Memory facepos = new Memory((long)bs);
        IntByReference detected = new IntByReference();
        int res = FSDK.FSDK_DetectMultipleFaces(Image2.himage, detected, (Pointer)facepos, bs);
        int det = detected.getValue();
        if (res == 0 && det > 0) {
            FacePositions.faces = new TFacePosition[det];
            for (int i = 0; i < det; ++i) {
                FacePositions.faces[i] = new TFacePosition((Pointer)facepos, i * 24);
            }
        }
        return res;
    }

    public static int SetFaceDetectionParameters(boolean HandleArbitraryRotations, boolean DetermineFaceRotationAngle, int InternalResizeWidth) {
        byte bHandleArbitraryRotations = (byte)(HandleArbitraryRotations ? 1 : 0);
        byte bDetermineFaceRotationAngle = (byte)(DetermineFaceRotationAngle ? 1 : 0);
        return FSDK.FSDK_SetFaceDetectionParameters(bHandleArbitraryRotations, bDetermineFaceRotationAngle, InternalResizeWidth);
    }

    public static int SetFaceDetectionThreshold(int Threshold) {
        return FSDK.FSDK_SetFaceDetectionThreshold(Threshold);
    }

    public static int SetJpegCompressionQuality(int Quality) {
        return FSDK.FSDK_SetJpegCompressionQuality(Quality);
    }

    public static int CopyImage(HImage SourceImage, HImage DestImage) {
        return FSDK.FSDK_CopyImage(SourceImage.himage, DestImage.himage);
    }

    public static int ResizeImage(HImage SourceImage, double ratio, HImage DestImage) {
        return FSDK.FSDK_ResizeImage(SourceImage.himage, ratio, DestImage.himage);
    }

    public static int RotateImage90(HImage SourceImage, int Multiplier, HImage DestImage) {
        return FSDK.FSDK_RotateImage90(SourceImage.himage, Multiplier, DestImage.himage);
    }

    public static int RotateImage(HImage SourceImage, double angle, HImage DestImage) {
        return FSDK.FSDK_RotateImage(SourceImage.himage, angle, DestImage.himage);
    }

    public static int RotateImageCenter(HImage SourceImage, double angle, double xCenter, double yCenter, HImage DestImage) {
        return FSDK.FSDK_RotateImageCenter(SourceImage.himage, angle, xCenter, yCenter, DestImage.himage);
    }

    public static int CopyRect(HImage SourceImage, int x1, int y1, int x2, int y2, HImage DestImage) {
        return FSDK.FSDK_CopyRect(SourceImage.himage, x1, y1, x2, y2, DestImage.himage);
    }

    public static int CopyRectReplicateBorder(HImage SourceImage, int x1, int y1, int x2, int y2, HImage DestImage) {
        return FSDK.FSDK_CopyRectReplicateBorder(SourceImage.himage, x1, y1, x2, y2, DestImage.himage);
    }

    public static int MirrorImage(HImage Image2, boolean UseVerticalMirroringInsteadOfHorizontal) {
        byte bUseVerticalMirroringInsteadOfHorizontal = (byte)(UseVerticalMirroringInsteadOfHorizontal ? 1 : 0);
        return FSDK.FSDK_MirrorImage(Image2.himage, bUseVerticalMirroringInsteadOfHorizontal);
    }

    public static int ExtractFaceImage(HImage Image2, FSDK_Features.ByReference FacialFeatures, int Width, int Height, HImage ExtractedFaceImage, FSDK_Features.ByReference ResizedFeatures) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_ExtractFaceImage(Image2.himage, FacialFeatures, Width, Height, tmp, ResizedFeatures);
        ExtractedFaceImage.himage = tmp.getValue();
        return res;
    }

    public static int GetFaceTemplate(HImage Image2, FSDK_FaceTemplate.ByReference FaceTemplate) {
        return FSDK.FSDK_GetFaceTemplate(Image2.himage, FaceTemplate);
    }

    public static int GetFaceTemplateInRegion(HImage Image2, TFacePosition FacePosition, FSDK_FaceTemplate.ByReference FaceTemplate) {
        return FSDK.FSDK_GetFaceTemplateInRegion(Image2.himage, FacePosition, FaceTemplate);
    }

    public static int GetFaceTemplateUsingFeatures(HImage Image2, FSDK_Features FacialFeatures, FSDK_FaceTemplate.ByReference FaceTemplate) {
        return FSDK.FSDK_GetFaceTemplateUsingFeatures(Image2.himage, FacialFeatures, FaceTemplate);
    }

    public static int GetFaceTemplateUsingEyes(HImage Image2, FSDK_Features EyeCoords, FSDK_FaceTemplate.ByReference FaceTemplate) {
        return FSDK.FSDK_GetFaceTemplateUsingEyes(Image2.himage, EyeCoords, FaceTemplate);
    }

    public static int MatchFaces(FSDK_FaceTemplate.ByReference FaceTemplate1, FSDK_FaceTemplate.ByReference FaceTemplate2, float[] Similarity) {
        if (Similarity.length < 1) {
            return -4;
        }
        FloatByReference tmp = new FloatByReference();
        int res = FSDK.FSDK_MatchFaces(FaceTemplate1, FaceTemplate2, tmp);
        Similarity[0] = tmp.getValue();
        return res;
    }

    public static int GetMatchingThresholdAtFAR(float FARValue, float[] Threshold) {
        if (Threshold.length < 1) {
            return -4;
        }
        FloatByReference tmp = new FloatByReference();
        int res = FSDK.FSDK_GetMatchingThresholdAtFAR(FARValue, tmp);
        Threshold[0] = tmp.getValue();
        return res;
    }

    public static int GetMatchingThresholdAtFRR(float FRRValue, float[] Threshold) {
        if (Threshold.length < 1) {
            return -4;
        }
        FloatByReference tmp = new FloatByReference();
        int res = FSDK.FSDK_GetMatchingThresholdAtFRR(FRRValue, tmp);
        Threshold[0] = tmp.getValue();
        return res;
    }

    public static int GetDetectedFaceConfidence(int[] Confidence) {
        if (Confidence.length < 1) {
            return -4;
        }
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_GetDetectedFaceConfidence(tmp);
        Confidence[0] = tmp.getValue();
        return res;
    }

    public static int CreateTracker(HTracker Tracker) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_CreateTracker(tmp);
        Tracker.htracker = tmp.getValue();
        return res;
    }

    public static int FreeTracker(HTracker Tracker) {
        return FSDK.FSDK_FreeTracker(Tracker.htracker);
    }

    public static int ClearTracker(HTracker Tracker) {
        return FSDK.FSDK_ClearTracker(Tracker.htracker);
    }

    public static int SetTrackerParameter(HTracker Tracker, String ParameterName, String ParameterValue) {
        return FSDK.FSDK_SetTrackerParameter(Tracker.htracker, ParameterName, ParameterValue);
    }

    public static int SetTrackerMultipleParameters(HTracker Tracker, String Parameters, int[] ErrorPosition) {
        if (ErrorPosition.length < 1) {
            return -4;
        }
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_SetTrackerMultipleParameters(Tracker.htracker, Parameters, tmp);
        ErrorPosition[0] = tmp.getValue();
        return res;
    }

    public static int SetParameter(String ParameterName, String ParameterValue) {
        return FSDK.FSDK_SetParameter(ParameterName, ParameterValue);
    }

    public static int SetParameters(String Parameters, int[] ErrorPosition) {
        if (ErrorPosition.length < 1) {
            return -4;
        }
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_SetParameters(Parameters, tmp);
        ErrorPosition[0] = tmp.getValue();
        return res;
    }

    public static int GetTrackerParameter(HTracker Tracker, String ParameterName, String[] ParameterValue, long MaxSizeInBytes) {
        if (MaxSizeInBytes < 1L || ParameterValue.length < 1) {
            return -4;
        }
        Memory buf = new Memory(MaxSizeInBytes);
        int res = FSDK.FSDK_GetTrackerParameter(Tracker.htracker, ParameterName, (Pointer)buf, MaxSizeInBytes);
        if (res == 0) {
            ParameterValue[0] = buf.getString(0L);
        }
        return res;
    }

    public static int FeedFrame(HTracker Tracker, long CameraIdx, HImage Image2, long[] FaceCount, long[] IDs) {
        int LONGLONGSIZE = 8;
        long IDsLen = IDs.length;
        long MaxSizeInBytes = IDsLen * 8L;
        if (FaceCount.length < 1 || IDsLen < 1L) {
            return -4;
        }
        LongByReference tmp = new LongByReference();
        Memory buf = new Memory(MaxSizeInBytes);
        int res = FSDK.FSDK_FeedFrame(Tracker.htracker, CameraIdx, Image2.himage, tmp, (Pointer)buf, MaxSizeInBytes);
        if (res == 0) {
            FaceCount[0] = tmp.getValue();
            int i = 0;
            while ((long)i < IDsLen) {
                IDs[i] = buf.getLong((long)(8 * i));
                ++i;
            }
        }
        return res;
    }

    public static int GetTrackerEyes(HTracker Tracker, long CameraIdx, long ID, FSDK_Features.ByReference FacialFeatures) {
        return FSDK.FSDK_GetTrackerEyes(Tracker.htracker, CameraIdx, ID, FacialFeatures);
    }

    public static int GetTrackerFacialFeatures(HTracker Tracker, long CameraIdx, long ID, FSDK_Features.ByReference FacialFeatures) {
        return FSDK.FSDK_GetTrackerFacialFeatures(Tracker.htracker, CameraIdx, ID, FacialFeatures);
    }

    public static int GetTrackerFacePosition(HTracker Tracker, long CameraIdx, long ID, TFacePosition.ByReference FacePosition) {
        return FSDK.FSDK_GetTrackerFacePosition(Tracker.htracker, CameraIdx, ID, FacePosition);
    }

    public static int LockID(HTracker Tracker, long ID) {
        return FSDK.FSDK_LockID(Tracker.htracker, ID);
    }

    public static int PurgeID(HTracker Tracker, long ID) {
        return FSDK.FSDK_PurgeID(Tracker.htracker, ID);
    }

    public static int UnlockID(HTracker Tracker, long ID) {
        return FSDK.FSDK_UnlockID(Tracker.htracker, ID);
    }

    public static int SetName(HTracker Tracker, long ID, String Name) {
        return FSDK.FSDK_SetName(Tracker.htracker, ID, Name);
    }

    public static int GetName(HTracker Tracker, long ID, String[] Name, long MaxSizeInBytes) {
        if (MaxSizeInBytes < 1L || Name.length < 1) {
            return -4;
        }
        Memory buf = new Memory(MaxSizeInBytes);
        int res = FSDK.FSDK_GetName(Tracker.htracker, ID, (Pointer)buf, MaxSizeInBytes);
        if (res == 0) {
            Name[0] = buf.getString(0L);
        }
        return res;
    }

    public static int GetAllNames(HTracker Tracker, long ID, String[] Names, long MaxSizeInBytes) {
        if (MaxSizeInBytes < 1L || Names.length < 1) {
            return -4;
        }
        Memory buf = new Memory(MaxSizeInBytes);
        int res = FSDK.FSDK_GetAllNames(Tracker.htracker, ID, (Pointer)buf, MaxSizeInBytes);
        if (res == 0) {
            Names[0] = buf.getString(0L);
        }
        return res;
    }

    public static int GetIDReassignment(HTracker Tracker, long ID, long[] ReassignedID) {
        if (ReassignedID.length < 1) {
            return -4;
        }
        LongByReference tmp = new LongByReference();
        int res = FSDK.FSDK_GetIDReassignment(Tracker.htracker, ID, tmp);
        if (res == 0) {
            ReassignedID[0] = tmp.getValue();
        }
        return res;
    }

    public static int GetSimilarIDCount(HTracker Tracker, long ID, long[] Count) {
        if (Count.length < 1) {
            return -4;
        }
        LongByReference tmp = new LongByReference();
        int res = FSDK.FSDK_GetSimilarIDCount(Tracker.htracker, ID, tmp);
        if (res == 0) {
            Count[0] = tmp.getValue();
        }
        return res;
    }

    public static int GetSimilarIDList(HTracker Tracker, long ID, long[] SimilarIDList) {
        int LONGLONGSIZE = 8;
        long sLen = SimilarIDList.length;
        long MaxSizeInBytes = sLen * 8L;
        if (sLen < 1L) {
            return -4;
        }
        Memory buf = new Memory(MaxSizeInBytes);
        int res = FSDK.FSDK_GetSimilarIDList(Tracker.htracker, ID, (Pointer)buf, MaxSizeInBytes);
        if (res == 0) {
            int i = 0;
            while ((long)i < sLen) {
                SimilarIDList[i] = buf.getLong((long)(8 * i));
                ++i;
            }
        }
        return res;
    }

    public static int GetTrackerIDsCount(HTracker Tracker, long[] Count) {
        if (Count.length < 1) {
            return -4;
        }
        LongByReference tmp = new LongByReference();
        int res = FSDK.FSDK_GetTrackerIDsCount(Tracker.htracker, tmp);
        if (res == 0) {
            Count[0] = tmp.getValue();
        }
        return res;
    }

    public static int GetTrackerAllIDs(HTracker Tracker, long[] IDList) {
        int LONGLONGSIZE = 8;
        long sLen = IDList.length;
        if (sLen < 1L) {
            return -4;
        }
        long MaxSizeInBytes = sLen * 8L;
        Memory buf = new Memory(MaxSizeInBytes);
        int res = FSDK.FSDK_GetTrackerAllIDs(Tracker.htracker, (Pointer)buf, MaxSizeInBytes);
        if (res == 0) {
            int i = 0;
            while ((long)i < sLen) {
                IDList[i] = buf.getLong((long)(8 * i));
                ++i;
            }
        }
        return res;
    }

    public static int GetTrackerFaceIDsCountForID(HTracker Tracker, long ID, long[] Count) {
        if (Count.length < 1) {
            return -4;
        }
        LongByReference tmp = new LongByReference();
        int res = FSDK.FSDK_GetTrackerFaceIDsCountForID(Tracker.htracker, ID, tmp);
        if (res == 0) {
            Count[0] = tmp.getValue();
        }
        return res;
    }

    public static int GetTrackerFaceIDsForID(HTracker Tracker, long ID, long[] FaceIDList) {
        int LONGLONGSIZE = 8;
        long sLen = FaceIDList.length;
        if (sLen < 1L) {
            return -4;
        }
        long MaxSizeInBytes = sLen * 8L;
        Memory buf = new Memory(MaxSizeInBytes);
        int res = FSDK.FSDK_GetTrackerFaceIDsForID(Tracker.htracker, ID, (Pointer)buf, MaxSizeInBytes);
        if (res == 0) {
            int i = 0;
            while ((long)i < sLen) {
                FaceIDList[i] = buf.getLong((long)(8 * i));
                ++i;
            }
        }
        return res;
    }

    public static int GetTrackerIDByFaceID(HTracker Tracker, long FaceID, long[] ID) {
        if (ID.length < 1) {
            return -4;
        }
        LongByReference tmp = new LongByReference();
        int res = FSDK.FSDK_GetTrackerIDByFaceID(Tracker.htracker, FaceID, tmp);
        if (res == 0) {
            ID[0] = tmp.getValue();
        }
        return res;
    }

    public static int GetTrackerFaceTemplate(HTracker Tracker, long FaceID, FSDK_FaceTemplate.ByReference FaceTemplate) {
        return FSDK.FSDK_GetTrackerFaceTemplate(Tracker.htracker, FaceID, FaceTemplate);
    }

    public static int TrackerCreateID(HTracker Tracker, FSDK_FaceTemplate.ByReference FaceTemplate, long[] ID, long[] FaceID) {
        if (ID.length < 1 || FaceID.length < 1) {
            return -4;
        }
        LongByReference id = new LongByReference();
        LongByReference faceID = new LongByReference();
        int res = FSDK.FSDK_TrackerCreateID(Tracker.htracker, FaceTemplate, id, faceID);
        if (res == 0) {
            ID[0] = id.getValue();
            FaceID[0] = faceID.getValue();
        }
        return res;
    }

    public static int AddTrackerFaceTemplate(HTracker Tracker, long ID, FSDK_FaceTemplate.ByReference FaceTemplate, long[] FaceID) {
        if (FaceID.length < 1) {
            return -4;
        }
        LongByReference tmp = new LongByReference();
        int res = FSDK.FSDK_AddTrackerFaceTemplate(Tracker.htracker, ID, FaceTemplate, tmp);
        if (res == 0) {
            FaceID[0] = tmp.getValue();
        }
        return res;
    }

    public static int DeleteTrackerFace(HTracker Tracker, long FaceID) {
        return FSDK.FSDK_DeleteTrackerFace(Tracker.htracker, FaceID);
    }

    public static int GetTrackerFaceImage(HTracker Tracker, long FaceID, HImage Image2) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_GetTrackerFaceImage(Tracker.htracker, FaceID, tmp);
        if (res == 0) {
            Image2.himage = tmp.getValue();
        }
        return res;
    }

    public static int SetTrackerFaceImage(HTracker Tracker, long FaceID, HImage Image2) {
        return FSDK.FSDK_SetTrackerFaceImage(Tracker.htracker, FaceID, Image2.himage);
    }

    public static int DeleteTrackerFaceImage(HTracker Tracker, long FaceID) {
        return FSDK.FSDK_DeleteTrackerFaceImage(Tracker.htracker, FaceID);
    }

    public static int TrackerMatchFaces(HTracker Tracker, FSDK_FaceTemplate.ByReference FaceTemplate, float Threshold, IDSimilarities Similarities) {
        long bs = 16 * Similarities.maxCount;
        Memory similarities = new Memory(bs);
        LongByReference count = new LongByReference();
        int res = FSDK.FSDK_TrackerMatchFaces(Tracker.htracker, FaceTemplate, Threshold, (Pointer)similarities, count, bs);
        int cnt = (int)count.getValue();
        if (res == 0 && cnt > 0) {
            Similarities.similarities = new IDSimilarity[cnt];
            for (int i = 0; i < cnt; ++i) {
                Similarities.similarities[i] = new IDSimilarity((Pointer)similarities, i * 16);
            }
        }
        return res;
    }

    public static int LoadTrackerMemoryFromFile(HTracker Tracker, String FileName) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_LoadTrackerMemoryFromFile(tmp, FileName);
        Tracker.htracker = tmp.getValue();
        return res;
    }

    public static int SaveTrackerMemoryToFile(HTracker Tracker, String FileName) {
        return FSDK.FSDK_SaveTrackerMemoryToFile(Tracker.htracker, FileName);
    }

    public static int LoadTrackerMemoryFromBuffer(HTracker Tracker, byte[] Buffer) {
        IntByReference tmp = new IntByReference();
        int res = FSDK.FSDK_LoadTrackerMemoryFromBuffer(tmp, Buffer);
        Tracker.htracker = tmp.getValue();
        return res;
    }

    public static int GetTrackerMemoryBufferSize(HTracker Tracker, long[] BufSize) {
        if (BufSize.length < 1) {
            return -4;
        }
        LongByReference tmp = new LongByReference();
        int res = FSDK.FSDK_GetTrackerMemoryBufferSize(Tracker.htracker, tmp);
        if (res == 0) {
            BufSize[0] = tmp.getValue();
        }
        return res;
    }

    public static int SaveTrackerMemoryToBuffer(HTracker Tracker, byte[] Buffer) {
        long MaxSizeInBytes = Buffer.length;
        if (MaxSizeInBytes < 1L) {
            return -4;
        }
        return FSDK.FSDK_SaveTrackerMemoryToBuffer(Tracker.htracker, Buffer, MaxSizeInBytes);
    }

    public static int GetTrackerFacialAttribute(HTracker Tracker, long CameraIdx, long ID, String AttributeName, String[] AttributeValues, long MaxSizeInBytes) {
        if (MaxSizeInBytes < 1L || AttributeValues.length < 1) {
            return -4;
        }
        Memory buf = new Memory(MaxSizeInBytes);
        int res = FSDK.FSDK_GetTrackerFacialAttribute(Tracker.htracker, CameraIdx, ID, AttributeName, (Pointer)buf, MaxSizeInBytes);
        if (res == 0) {
            AttributeValues[0] = buf.getString(0L);
        }
        return res;
    }

    public static int DetectFacialAttributeUsingFeatures(HImage Image2, FSDK_Features FacialFeatures, String AttributeName, String[] AttributeValues, long MaxSizeInBytes) {
        if (MaxSizeInBytes < 1L || AttributeValues.length < 1) {
            return -4;
        }
        Memory buf = new Memory(MaxSizeInBytes);
        int res = FSDK.FSDK_DetectFacialAttributeUsingFeatures(Image2.himage, FacialFeatures, AttributeName, (Pointer)buf, MaxSizeInBytes);
        if (res == 0) {
            AttributeValues[0] = buf.getString(0L);
        }
        return res;
    }

    public static int GetValueConfidence(String AttributeValues, String Value, float[] Confidence) {
        if (Confidence.length < 1) {
            return -4;
        }
        FloatByReference tmp = new FloatByReference();
        int res = FSDK.FSDK_GetValueConfidence(AttributeValues, Value, tmp);
        Confidence[0] = tmp.getValue();
        return res;
    }

    static {
        Native.register((NativeLibrary)library);
        if (Platform.isWindows() || Platform.isWindowsCE()) {
            _FSDK_SaveImageToFileW = library.getFunction("FSDK_SaveImageToFileW");
            _FSDK_LoadImageFromFileW = library.getFunction("FSDK_LoadImageFromFileW");
            _FSDK_LoadImageFromFileWithAlphaW = library.getFunction("FSDK_LoadImageFromFileWithAlphaW");
        } else {
            _FSDK_SaveImageToFileW = null;
            _FSDK_LoadImageFromFileW = null;
            _FSDK_LoadImageFromFileWithAlphaW = null;
        }
    }

    public static class HImage {
        protected int himage;
    }

    public static class FSDK_IMAGEMODE {
        public static final int FSDK_IMAGE_GRAYSCALE_8BIT = 0;
        public static final int FSDK_IMAGE_COLOR_24BIT = 1;
        public static final int FSDK_IMAGE_COLOR_32BIT = 2;
    }

    public static class TFacePosition
    extends Structure {
        public int xc;
        public int yc;
        public int w;
        public double angle;

        public TFacePosition() {
        }

        public TFacePosition(Pointer p, int offset) {
            this.xc = p.getInt((long)(offset + 0));
            this.yc = p.getInt((long)(offset + 4));
            this.w = p.getInt((long)(offset + 8));
            this.angle = p.getDouble((long)(offset + 16));
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("xc", "yc", "w", "angle");
        }

        public static class ByReference
        extends TFacePosition
        implements Structure.ByReference {
        }

        public static class ByValue
        extends TFacePosition
        implements Structure.ByValue {
        }
    }

    public static class FSDK_Features
    extends Structure {
        public TPoint[] features = new TPoint[70];

        protected List<String> getFieldOrder() {
            return Collections.singletonList("features");
        }

        public static class ByReference
        extends FSDK_Features
        implements Structure.ByReference {
        }

        public static class ByValue
        extends FSDK_Features
        implements Structure.ByValue {
        }
    }

    public static class TFaces {
        public TFacePosition[] faces;
        int maxFaces;

        public TFaces() {
            this.maxFaces = 100;
            this.faces = null;
        }

        public TFaces(int MaxFaces) {
            this.maxFaces = MaxFaces;
            this.faces = null;
        }
    }

    public static class FSDK_FaceTemplate
    extends Structure {
        public byte[] template = new byte[1040];

        protected List<String> getFieldOrder() {
            return Arrays.asList("template");
        }

        public static class ByReference
        extends FSDK_FaceTemplate
        implements Structure.ByReference {
        }

        public static class ByValue
        extends FSDK_FaceTemplate
        implements Structure.ByValue {
        }
    }

    public static class HTracker {
        protected int htracker;
    }

    public static class IDSimilarities {
        public IDSimilarity[] similarities;
        int maxCount;

        public IDSimilarities() {
            this.maxCount = 100;
            this.similarities = null;
        }

        public IDSimilarities(int MaxCount) {
            this.maxCount = MaxCount;
            this.similarities = null;
        }
    }

    public static class IDSimilarity {
        public long ID;
        public float Similarity;

        protected IDSimilarity(Pointer p, int offset) {
            this.ID = p.getLong((long)(offset + 0));
            this.Similarity = p.getFloat((long)(offset + 8));
        }
    }

    public static class TPoint
    extends Structure {
        public int x;
        public int y;

        protected List<String> getFieldOrder() {
            return Arrays.asList("x", "y");
        }

        public static class ByReference
        extends TPoint
        implements Structure.ByReference {
        }

        public static class ByValue
        extends TPoint
        implements Structure.ByValue {
        }
    }

    public static class FSDK_VIDEOCOMPRESSIONTYPE {
        public static final int FSDK_MJPEG = 0;
    }
}

