﻿Imports Luxand

Public Class MainForm
    Private camera As Camera = Nothing
    Private needClose As Boolean
    Private cameraOpened As Boolean

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            FSDK.ActivateLibrary("INSERT THE LICENSE KEY HERE")
            FSDK.InitializeLibrary()
        Catch ex As Exception
            MessageBox.Show("Please insert the license key in the FSDK.ActivateLibrary() function." & vbCrLf & ex.Message, "Error activating FaceSDK")
            Close()
        End Try
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        needClose = True
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Try
            If cameraOpened AndAlso camera IsNot Nothing Then
                camera.Dispose()
                camera = Nothing
            End If

            camera = New Camera(Camera.VideoCompressionType.MJPEG, AddressBox.Text, UsernameBox.Text, PasswordBox.Text, 50)
            cameraOpened = True
        Catch ex As Exception
            MessageBox.Show("Error opening IP camera: " & ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Application.Exit()
        End Try
    End Sub

    Private Sub Form1_Shown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Shown
        Using tracker As New Tracker()
            Dim err As Integer
            tracker.SetMultipleParameters("RecognizeFaces=false; HandleArbitraryRotations=false; DetermineFaceRotationAngle=false; InternalResizeWidth=100; FaceDetectionThreshold=5;", err)

            needClose = False
            cameraOpened = False

            Dim frameImage As Image
            While Not needClose
                If cameraOpened AndAlso camera IsNot Nothing Then
                    Try
                        Using image As CImage = camera.GrabFrame()
                            Dim IDs() As Long = Nothing
                            tracker.FeedFrame(image, IDs)

                            frameImage = image.ToCLRImage()

                            Using gr As Graphics = Graphics.FromImage(frameImage)
                                If IDs IsNot Nothing Then
                                    For Each id As Long In IDs
                                        Dim facePosition As FSDK.TFacePosition = tracker.GetFacePosition(0, id)

                                        Dim left As Integer = facePosition.xc - CInt(facePosition.w * 0.6)
                                        Dim top As Integer = facePosition.yc - CInt(facePosition.w * 0.5)
                                        gr.DrawRectangle(Pens.LightGreen, left, top, CInt(facePosition.w * 1.2), CInt(facePosition.w * 1.2))
                                    Next
                                End If
                            End Using

                            ' display current frame
                            PictureBox1.Image = frameImage
                        End Using
                    Catch ex As Exception
                        ' Ignore frame grab errors and continue
                        Application.DoEvents()
                        Continue While
                    End Try
                End If

                GC.Collect() ' collect the garbage after the deletion

                ' make UI controls accessible
                Application.DoEvents()
            End While

            If camera IsNot Nothing Then
                camera.Dispose()
            End If
        End Using
    End Sub
End Class
