﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Luxand;

namespace FaceTracking
{
    public partial class MainForm : Form
    {
        bool needClose = false;
        Camera camera = null;
        Tracker tracker = null;

        public MainForm()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            if (FSDK.FSDKE_OK != FSDK.ActivateLibrary("INSERT THE LICENSE KEY HERE"))
            {
                MessageBox.Show("Please insert the license key in the FSDK.ActivateLibrary() function.", "Error activating FaceSDK", MessageBoxButtons.OK, MessageBoxIcon.Error);
                Application.Exit();
            }

            FSDK.InitializeLibrary();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            needClose = true;
            camera?.Dispose();
            tracker?.Dispose();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                // Закрываем предыдущую камеру, если была открыта
                camera?.Dispose();

                // Открываем IP камеру
                camera = new Camera(Camera.VideoCompressionType.MJPEG, AddressBox.Text, UsernameBox.Text, PasswordBox.Text, 50);
            }
            catch (Exception ex)
            {
                MessageBox.Show($"Error opening IP camera: {ex.Message}", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void Form1_Shown(object sender, EventArgs e)
        {
            // Создаем трекер
            tracker = new Tracker();
            
            int err = 0; // set realtime face detection parameters
            tracker.SetMultipleParameters("RecognizeFaces=false; HandleArbitraryRotations=false; DetermineFaceRotationAngle=false; InternalResizeWidth=100; FaceDetectionThreshold=5;", out err);
            
            while (!needClose)
            {
                if (camera != null)
                {
                    try
                    {
                        // Захватываем кадр с камеры
                        using (CImage image = camera.GrabFrame())
                        {
                            // Подаем кадр в трекер
                            tracker.FeedFrame(image, out long[] faceIDs);

                            // Конвертируем изображение в CLR Image для отображения
                            Image frameImage = image.ToCLRImage();
                            Graphics gr = Graphics.FromImage(frameImage);

                            if (faceIDs != null)
                            {
                                for (int i = 0; i < faceIDs.Length; ++i)
                                {
                                    FSDK.TFacePosition facePosition = tracker.GetFacePosition(0, faceIDs[i]);

                                    int left = facePosition.xc - (int)(facePosition.w * 0.6);
                                    int top = facePosition.yc - (int)(facePosition.w * 0.5);
                                    gr.DrawRectangle(Pens.LightGreen, left, top, (int)(facePosition.w * 1.2), (int)(facePosition.w * 1.2));
                                }
                            }

                            // Отображаем кадр
                            pictureBox1.Image?.Dispose();
                            pictureBox1.Image = frameImage;
                        }
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show($"Error in frame processing: {ex.Message}", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        Application.DoEvents();
                        break;
                    }
                }

                GC.Collect(); // collect the garbage after the deletion

                // make UI controls accessible
                Application.DoEvents();
            }

            camera?.Dispose();
            tracker?.Dispose();
        }
    }
}
