/*
 * FacialFeaturesView.java
 * 
 * To edit GUI in visual editor of Netbeans 7.2+ you can install Swing Application Framework plugin:
 * http://plugins.netbeans.org/plugin/43853/swing-application-framework-support
 * Do not forget to restart Netbeans after installing the plugin!
 */

package facialfeatures;

import org.jdesktop.application.Action;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import java.awt.*;
import java.awt.image.BufferedImage;
import javax.swing.*;
import Luxand.*;
import Luxand.FSDK.*;

/**
 * The application's main frame.
 */
public class FacialFeaturesView extends FrameView {
   
    public FacialFeaturesView(SingleFrameApplication app) {
        super(app);

        initComponents();
      
        getFrame().setPreferredSize(new Dimension(width, height + 100));
        getFrame().setResizable(false);
        
        try {
            int r = FSDK.ActivateLibrary("INSERT THE LICENSE KEY HERE");
            if (r != FSDK.FSDKE_OK){
               JOptionPane.showMessageDialog(mainPanel, "Please insert the license key in the FSDK.ActivateLibrary() function.", "Error activating FaceSDK", JOptionPane.ERROR_MESSAGE); 
               System.exit(r);
            }
        } 
        catch(java.lang.UnsatisfiedLinkError e) {
            JOptionPane.showMessageDialog(mainPanel, e.toString(), "Link Error", JOptionPane.ERROR_MESSAGE);
            System.exit(1);
        }    
            
        FSDK.Initialize();
        FSDK.SetFaceDetectionParameters(true, true, 384);
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();

        mainPanel.setName("mainPanel"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(facialfeatures.FacialFeaturesApp.class).getContext().getActionMap(FacialFeaturesView.class, this);
        jButton1.setAction(actionMap.get("buttonOpen")); // NOI18N
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(facialfeatures.FacialFeaturesApp.class).getContext().getResourceMap(FacialFeaturesView.class);
        jButton1.setText(resourceMap.getString("jButton1.text")); // NOI18N
        jButton1.setName("jButton1"); // NOI18N

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap(357, Short.MAX_VALUE)
                .addComponent(jButton1)
                .addContainerGap())
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup()
                .addContainerGap(320, Short.MAX_VALUE)
                .addComponent(jButton1)
                .addContainerGap())
        );

        setComponent(mainPanel);
    }// </editor-fold>//GEN-END:initComponents

    @Action
    public void buttonOpen() {
        FileDialog dlg = new FileDialog((java.awt.Frame)null, "Open File", FileDialog.LOAD);
        dlg.setFile("*.jpg");
        dlg.show();
        String fileName = dlg.getDirectory() + dlg.getFile();
        
        HImage imageHandle = new HImage();
        if (FSDK.LoadImageFromFileW(imageHandle, fileName) == FSDK.FSDKE_OK){
            
            // resize image to fit the window width/height
            int imageWidthByReference[] = new int[1];
            int imageHeightByReference[] = new int[1];
            FSDK.GetImageWidth(imageHandle, imageWidthByReference);
            FSDK.GetImageHeight(imageHandle, imageHeightByReference);
            int imageWidth = imageWidthByReference[0];
            int imageHeight = imageHeightByReference[0];
            double ratio = java.lang.Math.min((width + 0.4) / imageWidth,
                (height + 0.4) / imageHeight);
            HImage image2Handle = new HImage();
            FSDK.CreateEmptyImage(image2Handle);
            FSDK.ResizeImage(imageHandle, ratio, image2Handle);
            FSDK.CopyImage(image2Handle, imageHandle);
            FSDK.FreeImage(image2Handle);

            
            // save image into awt.Image
            Image awtImage[] = new Image[1];
            if (FSDK.SaveImageToAWTImage(imageHandle, awtImage, FSDK.FSDK_IMAGEMODE.FSDK_IMAGE_COLOR_24BIT) != FSDK.FSDKE_OK){
                JOptionPane.showMessageDialog(mainPanel, "Error displaying picture"); 
            } else {
                Image img = awtImage[0];
                BufferedImage bimg = null;
            
                FSDK.TFacePosition.ByReference facePosition = new FSDK.TFacePosition.ByReference();
                if (FSDK.DetectFace(imageHandle, facePosition) != FSDK.FSDKE_OK){
                    JOptionPane.showMessageDialog(mainPanel, "No faces found"); 
                } else {
                    bimg = new BufferedImage(img.getWidth(null), img.getHeight(null), BufferedImage.TYPE_INT_ARGB);
                    Graphics gr = bimg.getGraphics(); 
                    gr.drawImage(img, 0, 0, null);
                    gr.setColor(Color.green);
                
                    int left = facePosition.xc - facePosition.w / 2;
                    int top = facePosition.yc - facePosition.w / 2;
                    gr.drawRect(left, top, facePosition.w, facePosition.w);
                    
                    FSDK_Features.ByReference facialFeatures = new FSDK_Features.ByReference();
                    FSDK.DetectFacialFeaturesInRegion(imageHandle, (FSDK.TFacePosition)facePosition, facialFeatures);
                
                    for (int i = 0; i < FSDK.FSDK_FACIAL_FEATURE_COUNT; ++i){
                        if (i<2)
                            gr.setColor(Color.blue);
                        else if (i==2)
                            gr.setColor(Color.green);
                            
                        gr.drawOval(facialFeatures.features[i].x, facialFeatures.features[i].y, 3, 3);
                    }
                    
                    gr.dispose();
                }
                
                
                // draw image on window
                imagePanel.setImage((bimg != null) ? bimg : img);
                GroupLayout layout = (GroupLayout)mainPanel.getLayout();
                layout.setHorizontalGroup(
                    layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup().addComponent(imagePanel))
                );
                layout.setVerticalGroup(
                    layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(imagePanel))
                );
                
            }
            
            FSDK.FreeImage(imageHandle);
        }
    }
    
    public void closeFrame(){
        FSDK.Finalize();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel mainPanel;
    // End of variables declaration//GEN-END:variables

    private final int width = 640;
    private final int height = 480;
    
    
    
    // component to draw image on
    class ImagePanel extends JPanel {
        Image image;
        public void setImage(Image image) {
            this.image = image;
        }
        @Override
        public void paintComponent(Graphics gr) {
            if(image != null) {
                gr.clearRect(0, 0, width, height);
                gr.drawImage(image, 0, 0, this);
            }
        }
        @Override
        public Dimension getPreferredSize() {
            int w, h;
            if(image == null) {
                return new Dimension(0, 0);
            }
            w = image.getWidth(null);
            h = image.getHeight(null);
            return new Dimension((w > 0) ? w : 0, (h > 0) ? h : 0);
        }
    }
    private final ImagePanel imagePanel = new ImagePanel();
    
}
