## [FaceSDK](https://www.luxand.com/facesdk/?utm_source=github&utm_medium=readmd&utm_campaign=header) · [CloudAPI](https://luxand.cloud/?utm_source=github&utm_medium=readmd&utm_campaign=header) · [LinkedIn](https://www.linkedin.com/company/luxand-inc.) · [Contact](mailto:support@luxand.com)


<table style="border-collapse: collapse; border: none;">

# FaceSDK \- React Native (iOS, Android)

## Worklets fix
Replace line 19 in `example/node_modules/react-native-vision-camera/src/frame-processors/runAsync.ts`
```ts
const asyncContext = Worklets.createContext('VisionCamera.async')
```
with
```ts
const asyncContext = Worklets.defaultContext
```

This allows `runAsync` function to work in release builds.

## Running the sample

Before you start, ensure you have the following installed on your machine:

 - Node.js (https://nodejs.org)
 - npm (Node Package Manager, usually installed with Node.js), yarn (npm install -g yarn)
 - Xcode (for iOS development)

Install the dependencies:

```bash
cd example
yarn install
```

### iOS

For iOS you also need to install CocoaPods:

```bash
cd example/ios
pod install
```

You have two options to run the Sample on iOS:

#### Option 1: Using React Native CLI

Run the app using the React Native CLI:

```bash
yarn example ios
```

This will launch the app on the iOS simulator or a connected device.

#### Option 2: Using Xcode

1. Open Xcode on your Mac.

2. Open the iOS project by navigating to the "ios" folder and double-clicking the `.xcworkspace` file.

3. Once Xcode is open, select the target device or simulator you want to run the app on from the dropdown menu in the top-left corner.

4. Click the "Run" button (▶️) to build and run the app on the selected device/simulator.

If you encounter any issues during the setup or while running the app, please check the following:

- Ensure you have installed CocoaPods, Node.js, npm, yarn.

- Make sure the correct target device/simulator is selected in Xcode if you're using Option 2 for running the app.

### Android

You need to install CMake and NDK (v28.2.13676358) using the Android Package Manager. You have two options to run the Sample app on Android:

##### Option 1: Using React Native CLI

Run the app using the React Native CLI:

```bash
yarn example android
```

This will launch the app on the Android emulator or a connected Android device.

##### Option 2: Using Android Studio

1. Open Android Studio on your computer.

2. Click on "Open an existing Android Studio project" or "File" > "Open" from the top menu.

3. Navigate to the "example/android" folder and select it.

4. Wait for Android Studio to index the files and download any necessary Gradle dependencies. This might take a few minutes.

5. Once everything is set up, you should see a green "Run" button (▶️) at the top. Beside it, there's a dropdown menu. From this dropdown, you can select the Android emulator you've previously set up or any connected Android device.

6. Click the "Run" button (▶️) to build and run the app on the selected device/emulator.

**Note**: Before running the app on a real device, ensure that your device has USB Debugging enabled and is set to "File Transfer" mode. You might also need to confirm a prompt on your device to allow USB debugging from your computer.