from __future__ import print_function # for compatability with Python 2.x
import sys, os.path, base64
from fsdk import FSDK

db_filename = "faces.db"

if len(sys.argv) not in (2, 3):
	print('\nUsage: lookalikes.py <image_file> [option]')
	print('Options:')
	print('\t-a\tadd photo to database')
	print('\t-r\tremove photo from database')
	exit(-1)

filename = os.path.normcase(os.path.abspath(sys.argv[1]))
option = len(sys.argv)==3 and sys.argv[2] or ''
if option not in ('','-a','-r'): print('Unrecognized option:', option); exit(-1)

print("Initializing FSDK... ", end='')
FSDK.ActivateLibrary(""); 
FSDK.Initialize()
print("OK\nLicense info:", FSDK.GetLicenseInfo())

FSDK.SetFaceDetectionParameters(True, True, 384)  # HandleArbitraryRotations, DetermineFaceRotationAngle, InternalResizeWidthTrue
FSDK.SetFaceDetectionThreshold(3)
face_template = FSDK.Image(filename).GetFaceTemplate() # get template of detected face

if option=='-a': # add photo to database
	with open(db_filename, 'a+') as db:
		ft = base64.b64encode(face_template).decode('utf-8')
		print(filename, ft, file=db)
		print(os.path.basename(filename), 'is added to the database.')
	exit(0)

try: # read all photo from database
	with open(db_filename) as db: base = dict(l.rsplit(' ', 1) for l in db if l)
except FileNotFoundError:
	print('\nCannot open', db_filename, 'database file.\nUse "-a" option to create database.'); exit(1)

if option == '-r': # remove photo from database
	if filename in base:
		del base[filename]
		with open(db_filename, 'w') as db:
			for n in base: print(n, base[n], file=db)
		print(filename, 'is removed from database.')
	else: print(filename, 'is not found in database.')
	exit(0)

# find and print top 20 most similar face files
src = ((n, FSDK.FaceTemplate(*base64.b64decode(ft))) for n, ft in base.items())
matches = sorted(((face_template.Match(ft)*100, n) for n, ft in src), reverse = True)[:20]

print('\nFound similarities:', len(matches) or None)
for match in matches: print('%i%%\t%s'%match)
