import http.server
import socketserver
import os
import posixpath
import re
from io import BytesIO

PORT = 80

class MyHTTPRequestHandler(http.server.SimpleHTTPRequestHandler):
    def end_headers(self):
        self.send_my_headers()
        http.server.SimpleHTTPRequestHandler.end_headers(self)

    def send_my_headers(self):
        self.send_header("Cross-Origin-Embedder-Policy", "require-corp")
        self.send_header("Cross-Origin-Opener-Policy", "same-origin")
        self.send_header("Access-Control-Allow-Origin", "same-origin")

    def do_POST(self):
        content_length = int(self.headers['Content-Length'])
        body = self.rfile.read(content_length)
        self.send_response(200)
        self.send_header('Content-type', 'text/html')
        self.end_headers()
        response = BytesIO()
        response.write(b'This is POST request. ')
        response.write(b'Received: ')
        response.write(body)
        self.wfile.write(response.getvalue())
        
        file = open(self.path[1:], 'wb')
        file.write(body)
        file.close()

Handler = MyHTTPRequestHandler
Handler.extensions_map.update({ ".js": "application/javascript", });

httpd = socketserver.TCPServer(("", PORT), Handler)
httpd.serve_forever()
