/*
 * Decompiled with CFR 0.152.
 */
package Luxand;

import Luxand.FSDK;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class FSDKCam {
    private static final NativeLibrary library = NativeLibrary.getInstance((String)(Platform.isWindows() || Platform.isWindowsCE() ? "facesdk" : "fsdk"));
    private static final Pointer FSDK_VIDEO_FORMAT_SIZE = library.getGlobalVariableAddress("FSDK_VIDEO_FORMAT_SIZE");
    private static final Pointer FSDK_VideoFormatDescription = library.getGlobalVariableAddress("FSDK_VideoFormatDescription");
    public static final int VIDEO_FORMAT_SIZE;
    public static final String[] VideoFormatDescription;

    private static native int FSDK_SetHTTPProxy(String var0, short var1, String var2, String var3);

    private static native int FSDK_InitializeCapturing();

    private static native int FSDK_FinalizeCapturing();

    private static native int FSDK_GetCameraList(PointerByReference var0, IntByReference var1);

    private static native int FSDK_GetCameraListEx(PointerByReference var0, PointerByReference var1, IntByReference var2);

    private static native int FSDK_FreeCameraList(Pointer var0, int var1);

    private static native int FSDK_OpenIPVideoCamera(int var0, String var1, String var2, String var3, int var4, IntByReference var5);

    private static native int FSDK_OpenVideoCamera(byte[] var0, IntByReference var1);

    private static native int FSDK_CloseVideoCamera(int var0);

    private static native int FSDK_GrabFrame(int var0, IntByReference var1);

    private static native int FSDK_SetCameraNaming(byte var0);

    private static native int FSDK_GetVideoFormatList(byte[] var0, PointerByReference var1, IntByReference var2);

    private static native int FSDK_FreeVideoFormatList(Pointer var0);

    private static native int FSDK_SetVideoFormat(byte[] var0, FSDK_VideoFormatInfo.ByValue var1);

    public static int SetHTTPProxy(String ServerNameOrIPAddress, int Port, String UserName, String Password) {
        if (Port < 0 || Port > 65535) {
            return -4;
        }
        return FSDKCam.FSDK_SetHTTPProxy(ServerNameOrIPAddress, (short)Port, UserName, Password);
    }

    public static int InitializeCapturing() {
        return FSDKCam.FSDK_InitializeCapturing();
    }

    public static int FinalizeCapturing() {
        return FSDKCam.FSDK_FinalizeCapturing();
    }

    public static int GetCameraList(TCameras CameraList, int[] CameraCount) {
        if (CameraUtil.isEnabled()) {
            if (CameraCount.length < 1) {
                return -4;
            }
            PointerByReference ptmp = new PointerByReference();
            IntByReference tmp = new IntByReference();
            int res = FSDKCam.FSDK_GetCameraList(ptmp, tmp);
            if (res == 0) {
                int cnt = tmp.getValue();
                Pointer p = ptmp.getValue();
                CameraList.cameras = CameraUtil.getPlatformStringArray(p, cnt);
                CameraCount[0] = cnt;
                FSDKCam.FSDK_FreeCameraList(p, cnt);
            }
            return res;
        }
        return -1;
    }

    public static int GetCameraListEx(TCameras CameraNameList, TCameras CameraDevicePathList, int[] CameraCount) {
        if (CameraUtil.isEnabled()) {
            if (CameraCount.length < 1) {
                return -4;
            }
            PointerByReference ptmp = new PointerByReference();
            PointerByReference ptmp2 = new PointerByReference();
            IntByReference tmp = new IntByReference();
            int res = FSDKCam.FSDK_GetCameraListEx(ptmp, ptmp2, tmp);
            if (res == 0) {
                int cnt = tmp.getValue();
                Pointer p = ptmp.getValue();
                Pointer p2 = ptmp2.getValue();
                CameraNameList.cameras = CameraUtil.getPlatformStringArray(p, cnt);
                CameraDevicePathList.cameras = CameraUtil.getPlatformStringArray(p2, cnt);
                CameraCount[0] = cnt;
                FSDKCam.FSDK_FreeCameraList(p, cnt);
                FSDKCam.FSDK_FreeCameraList(p2, cnt);
            }
            return res;
        }
        return -1;
    }

    public static int OpenIPVideoCamera(int CompressionType, String URL2, String Username, String Password, int TimeoutSeconds, HCamera CameraHandle) {
        IntByReference tmp = new IntByReference();
        int res = FSDKCam.FSDK_OpenIPVideoCamera(CompressionType, URL2, Username, Password, TimeoutSeconds, tmp);
        CameraHandle.hcamera = tmp.getValue();
        return res;
    }

    public static int CloseVideoCamera(HCamera CameraHandle) {
        return FSDKCam.FSDK_CloseVideoCamera(CameraHandle.hcamera);
    }

    public static int GrabFrame(HCamera CameraHandle, FSDK.HImage Image2) {
        IntByReference tmp = new IntByReference();
        int res = FSDKCam.FSDK_GrabFrame(CameraHandle.hcamera, tmp);
        Image2.himage = tmp.getValue();
        return res;
    }

    public static int OpenVideoCamera(String CameraName, HCamera CameraHandle) {
        if (CameraUtil.isEnabled()) {
            IntByReference tmp = new IntByReference();
            int res = FSDKCam.FSDK_OpenVideoCamera(CameraUtil.getBytes(CameraName), tmp);
            CameraHandle.hcamera = tmp.getValue();
            return res;
        }
        return -1;
    }

    public static int SetCameraNaming(boolean UseDevicePathAsName) {
        if (CameraUtil.isEnabled()) {
            byte bUseDevicePathAsName = (byte)(UseDevicePathAsName ? 1 : 0);
            return FSDKCam.FSDK_SetCameraNaming(bUseDevicePathAsName);
        }
        return -1;
    }

    public static int GetVideoFormatList(String CameraName, FSDK_VideoFormats VideoFormatList, int[] VideoFormatCount) {
        if (CameraUtil.isEnabled()) {
            if (VideoFormatCount.length < 1) {
                return -4;
            }
            PointerByReference ptmp = new PointerByReference();
            IntByReference count = new IntByReference();
            int res = FSDKCam.FSDK_GetVideoFormatList(CameraUtil.getBytes(CameraName), ptmp, count);
            if (res == 0) {
                int cnt = count.getValue();
                VideoFormatList.formats = new FSDK_VideoFormatInfo.ByValue[cnt];
                Pointer pt = ptmp.getValue();
                for (int i = 0; i < cnt; ++i) {
                    VideoFormatList.formats[i] = new FSDK_VideoFormatInfo.ByValue();
                    VideoFormatList.formats[i].Width = pt.getInt((long)(i * 12 + 0));
                    VideoFormatList.formats[i].Height = pt.getInt((long)(i * 12 + 4));
                    VideoFormatList.formats[i].BPP = pt.getInt((long)(i * 12 + 8));
                }
                VideoFormatCount[0] = cnt;
                FSDKCam.FSDK_FreeVideoFormatList(pt);
            }
            return res;
        }
        return -1;
    }

    public static int SetVideoFormat(String CameraName, FSDK_VideoFormatInfo.ByValue VideoFormat) {
        if (CameraUtil.isEnabled()) {
            return FSDKCam.FSDK_SetVideoFormat(CameraUtil.getBytes(CameraName), VideoFormat);
        }
        return -1;
    }

    static {
        Native.register((NativeLibrary)library);
        VIDEO_FORMAT_SIZE = FSDK_VIDEO_FORMAT_SIZE.getInt(0L);
        VideoFormatDescription = CameraUtil.getStringArray(FSDK_VideoFormatDescription, VIDEO_FORMAT_SIZE);
    }

    private static class CameraUtil {
        private static Boolean enabled;
        private static String encoding;
        private static final GetWideStringArrayFunction getWideStringArrayFunction;

        private CameraUtil() {
        }

        public static boolean isEnabled() {
            if (enabled != null) {
                return enabled;
            }
            enabled = Platform.isWindows() || Platform.isWindowsCE() || Platform.isLinux();
            return enabled;
        }

        public static String getEncoding() {
            if (encoding != null) {
                return encoding;
            }
            encoding = Platform.isLinux() ? "UTF-8" : "UTF-16LE";
            return encoding;
        }

        public static String[] getPlatformStringArray(Pointer pointer, int length) {
            return Platform.isLinux() ? CameraUtil.getStringArray(pointer, length) : CameraUtil.getWideStringArray(pointer, length);
        }

        public static String[] getWideStringArray(Pointer pointer, int length) {
            return getWideStringArrayFunction.call(pointer, 0L, length);
        }

        public static String[] getStringArray(Pointer pointer, int length) {
            return pointer.getStringArray(0L, length);
        }

        private static byte[] getBytes(String value) {
            try {
                byte[] bytes = value.getBytes(CameraUtil.getEncoding());
                byte[] result = new byte[bytes.length + (Platform.isLinux() ? 1 : 2)];
                System.arraycopy(bytes, 0, result, 0, bytes.length);
                return result;
            }
            catch (UnsupportedEncodingException e) {
                return new byte[1];
            }
        }

        static {
            GetWideStringArrayFunction wideStringMethod;
            enabled = null;
            encoding = null;
            Package pkg = Native.class.getPackage();
            int version = Integer.parseInt(pkg.getSpecificationVersion().substring(0, 1));
            try {
                if (version < 5) {
                    final Method method = Pointer.class.getMethod("getStringArray", Long.TYPE, Integer.TYPE, Boolean.TYPE);
                    wideStringMethod = new GetWideStringArrayFunction(){

                        @Override
                        public String[] call(Pointer pointer, long offset, int length) {
                            try {
                                return (String[])method.invoke((Object)pointer, offset, length, true);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            return new String[1];
                        }
                    };
                } else {
                    final Method method = Pointer.class.getMethod("getWideStringArray", Long.TYPE, Integer.TYPE);
                    wideStringMethod = new GetWideStringArrayFunction(){

                        @Override
                        public String[] call(Pointer pointer, long offset, int length) {
                            try {
                                return (String[])method.invoke((Object)pointer, offset, length);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            return new String[1];
                        }
                    };
                }
            }
            catch (NoSuchMethodException e) {
                wideStringMethod = null;
                e.printStackTrace();
                System.exit(-1);
            }
            getWideStringArrayFunction = wideStringMethod;
        }

        private static interface GetWideStringArrayFunction {
            public String[] call(Pointer var1, long var2, int var4);
        }
    }

    public static class TCameras {
        public String[] cameras;
    }

    public static class HCamera {
        protected int hcamera;
    }

    public static class FSDK_VideoFormatInfo
    extends Structure {
        public int Width;
        public int Height;
        public int BPP;

        public String toString() {
            return Integer.toString(this.Width).trim() + "x" + Integer.toString(this.Height).trim() + ", " + Integer.toString(this.BPP).trim() + " BPP";
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("Width", "Height", "BPP");
        }

        public static class ByReference
        extends FSDK_VideoFormatInfo
        implements Structure.ByReference {
        }

        public static class ByValue
        extends FSDK_VideoFormatInfo
        implements Structure.ByValue {
        }
    }

    public static class FSDK_VideoFormats {
        public FSDK_VideoFormatInfo.ByValue[] formats;
    }
}

